@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ikeAuthAlg IKE auth Algorithm.
 * @property ikeEncAlg IKE encript algorithm.
 * @property ikeLifetime IKE lifetime.
 * @property ikeLocalId The local ID, which supports the FQDN and IP formats, and defaults to the IP address of the selected VPN gateway.
 * @property ikeMode IKE mode, supports main and aggressive mode. The main mode is highly secure. If NAT traversal is enabled, we recommend that you use the aggressive mode.
 * @property ikePfs DH group.
 * @property ikeRemoteId The peer ID. The FQDN and IP address formats are supported. The default value is the IP address of the selected customer gateway.
 * @property ikeVersion IKE version.
 * @property psk Preshared secret key.
 */
public data class ConnectionIkeConfig(
    public val ikeAuthAlg: String? = null,
    public val ikeEncAlg: String? = null,
    public val ikeLifetime: Int? = null,
    public val ikeLocalId: String? = null,
    public val ikeMode: String? = null,
    public val ikePfs: String? = null,
    public val ikeRemoteId: String? = null,
    public val ikeVersion: String? = null,
    public val psk: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.ConnectionIkeConfig): ConnectionIkeConfig = ConnectionIkeConfig(
            ikeAuthAlg = javaType.ikeAuthAlg().map({ args0 -> args0 }).orElse(null),
            ikeEncAlg = javaType.ikeEncAlg().map({ args0 -> args0 }).orElse(null),
            ikeLifetime = javaType.ikeLifetime().map({ args0 -> args0 }).orElse(null),
            ikeLocalId = javaType.ikeLocalId().map({ args0 -> args0 }).orElse(null),
            ikeMode = javaType.ikeMode().map({ args0 -> args0 }).orElse(null),
            ikePfs = javaType.ikePfs().map({ args0 -> args0 }).orElse(null),
            ikeRemoteId = javaType.ikeRemoteId().map({ args0 -> args0 }).orElse(null),
            ikeVersion = javaType.ikeVersion().map({ args0 -> args0 }).orElse(null),
            psk = javaType.psk().map({ args0 -> args0 }).orElse(null),
        )
    }
}
