@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property customerGatewayId The ID of the customer gateway in Tunnel.
 * @property enableDpd Wether enable Dpd detection.
 * @property enableNatTraversal enable nat traversal.
 * @property internetIp The local internet IP in Tunnel.
 * @property role The role of Tunnel.
 * @property state The state of Tunnel.
 * @property status The negotiation status of Tunnel.
 * @property tunnelBgpConfig The bgp config of Tunnel. See `tunnel_bgp_config` below.
 * @property tunnelId The tunnel ID of IPsec-VPN connection.
 * @property tunnelIkeConfig The configuration of Phase 1 negotiations in Tunnel. See `tunnel_ike_config` below.
 * @property tunnelIpsecConfig IPsec configuration in Tunnel. See `tunnel_ipsec_config` below.
 * @property zoneNo The zoneNo of tunnel.
 */
public data class ConnectionTunnelOptionsSpecification(
    public val customerGatewayId: String? = null,
    public val enableDpd: Boolean? = null,
    public val enableNatTraversal: Boolean? = null,
    public val internetIp: String? = null,
    public val role: String? = null,
    public val state: String? = null,
    public val status: String? = null,
    public val tunnelBgpConfig: ConnectionTunnelOptionsSpecificationTunnelBgpConfig? = null,
    public val tunnelId: String? = null,
    public val tunnelIkeConfig: ConnectionTunnelOptionsSpecificationTunnelIkeConfig? = null,
    public val tunnelIpsecConfig: ConnectionTunnelOptionsSpecificationTunnelIpsecConfig? = null,
    public val zoneNo: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.ConnectionTunnelOptionsSpecification): ConnectionTunnelOptionsSpecification = ConnectionTunnelOptionsSpecification(
            customerGatewayId = javaType.customerGatewayId().map({ args0 -> args0 }).orElse(null),
            enableDpd = javaType.enableDpd().map({ args0 -> args0 }).orElse(null),
            enableNatTraversal = javaType.enableNatTraversal().map({ args0 -> args0 }).orElse(null),
            internetIp = javaType.internetIp().map({ args0 -> args0 }).orElse(null),
            role = javaType.role().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tunnelBgpConfig = javaType.tunnelBgpConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.ConnectionTunnelOptionsSpecificationTunnelBgpConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tunnelId = javaType.tunnelId().map({ args0 -> args0 }).orElse(null),
            tunnelIkeConfig = javaType.tunnelIkeConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.ConnectionTunnelOptionsSpecificationTunnelIkeConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tunnelIpsecConfig = javaType.tunnelIpsecConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.ConnectionTunnelOptionsSpecificationTunnelIpsecConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            zoneNo = javaType.zoneNo().map({ args0 -> args0 }).orElse(null),
        )
    }
}
