@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bgpStatus Whether BGP function is turned on.
 * @property localAsn
 * @property localBgpIp
 * @property peerAsn Peer asn.
 * @property peerBgpIp Peer bgp ip.
 * @property tunnelCidr
 */
public data class ConnectionTunnelOptionsSpecificationTunnelBgpConfig(
    public val bgpStatus: String? = null,
    public val localAsn: String? = null,
    public val localBgpIp: String? = null,
    public val peerAsn: String? = null,
    public val peerBgpIp: String? = null,
    public val tunnelCidr: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.ConnectionTunnelOptionsSpecificationTunnelBgpConfig): ConnectionTunnelOptionsSpecificationTunnelBgpConfig =
            ConnectionTunnelOptionsSpecificationTunnelBgpConfig(
                bgpStatus = javaType.bgpStatus().map({ args0 -> args0 }).orElse(null),
                localAsn = javaType.localAsn().map({ args0 -> args0 }).orElse(null),
                localBgpIp = javaType.localBgpIp().map({ args0 -> args0 }).orElse(null),
                peerAsn = javaType.peerAsn().map({ args0 -> args0 }).orElse(null),
                peerBgpIp = javaType.peerBgpIp().map({ args0 -> args0 }).orElse(null),
                tunnelCidr = javaType.tunnelCidr().map({ args0 -> args0 }).orElse(null),
            )
    }
}
