@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enable Whether to enable BGP.
 * @property localAsn The ASN on the Alibaba Cloud side.
 * @property localBgpIp The BGP IP address on the Alibaba Cloud side.
 * @property tunnelCidr The CIDR block of the IPsec tunnel. The CIDR block belongs to 169.254.0.0/16. The mask of the CIDR block is 30 bits in length.
 */
public data class GatewayVpnAttachmentBgpConfig(
    public val enable: Boolean? = null,
    public val localAsn: Int? = null,
    public val localBgpIp: String? = null,
    public val tunnelCidr: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GatewayVpnAttachmentBgpConfig): GatewayVpnAttachmentBgpConfig = GatewayVpnAttachmentBgpConfig(
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            localAsn = javaType.localAsn().map({ args0 -> args0 }).orElse(null),
            localBgpIp = javaType.localBgpIp().map({ args0 -> args0 }).orElse(null),
            tunnelCidr = javaType.tunnelCidr().map({ args0 -> args0 }).orElse(null),
        )
    }
}
