@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dip The destination IP address that is used for health checks.
 * @property enable Specifies whether to enable health checks.
 * @property interval The interval between two consecutive health checks. Unit: seconds.
 * @property policy Whether to revoke the published route when the health check fails. Valid values: `revoke_route` or `reserve_route`.
 * @property retry The maximum number of health check retries.
 * @property sip The source IP address that is used for health checks.
 */
public data class GatewayVpnAttachmentHealthCheckConfig(
    public val dip: String? = null,
    public val enable: Boolean? = null,
    public val interval: Int? = null,
    public val policy: String? = null,
    public val retry: Int? = null,
    public val sip: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GatewayVpnAttachmentHealthCheckConfig): GatewayVpnAttachmentHealthCheckConfig = GatewayVpnAttachmentHealthCheckConfig(
            dip = javaType.dip().map({ args0 -> args0 }).orElse(null),
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 -> args0 }).orElse(null),
            retry = javaType.retry().map({ args0 -> args0 }).orElse(null),
            sip = javaType.sip().map({ args0 -> args0 }).orElse(null),
        )
    }
}
