@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ikeAuthAlg IKE authentication algorithm supports sha1 and MD5.
 * @property ikeEncAlg The encryption algorithm of phase-one negotiation. Valid value: aes | aes192 | aes256 | des | 3des. Default Valid value: aes.
 * @property ikeLifetime The SA lifecycle as the result of phase-one negotiation. The valid value of n is [0, 86400], the unit is second and the default value is 86400.
 * @property ikeMode The negotiation mode of IKE V1. Valid value: main (main mode) | aggressive (aggressive mode). Default value: `main`.
 * @property ikePfs The Diffie-Hellman key exchange algorithm used by phase-one negotiation. Valid value: group1 | group2 | group5 | group14 | group24. Default value: group2
 * @property ikeVersion The version of the IKE protocol. Valid value: `ikev1`, `ikev2`. Default value: `ikev1`.
 * @property localId The local ID, which supports the FQDN and IP formats. The current VPN gateway IP address is selected by default.
 * @property psk Used for authentication between the IPsec VPN gateway and the customer gateway.
 * @property remoteId The peer ID, which supports FQDN and IP formats. By default, the IP address of the currently selected user gateway.
 */
public data class GatewayVpnAttachmentIkeConfig(
    public val ikeAuthAlg: String? = null,
    public val ikeEncAlg: String? = null,
    public val ikeLifetime: Int? = null,
    public val ikeMode: String? = null,
    public val ikePfs: String? = null,
    public val ikeVersion: String? = null,
    public val localId: String? = null,
    public val psk: String? = null,
    public val remoteId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GatewayVpnAttachmentIkeConfig): GatewayVpnAttachmentIkeConfig = GatewayVpnAttachmentIkeConfig(
            ikeAuthAlg = javaType.ikeAuthAlg().map({ args0 -> args0 }).orElse(null),
            ikeEncAlg = javaType.ikeEncAlg().map({ args0 -> args0 }).orElse(null),
            ikeLifetime = javaType.ikeLifetime().map({ args0 -> args0 }).orElse(null),
            ikeMode = javaType.ikeMode().map({ args0 -> args0 }).orElse(null),
            ikePfs = javaType.ikePfs().map({ args0 -> args0 }).orElse(null),
            ikeVersion = javaType.ikeVersion().map({ args0 -> args0 }).orElse(null),
            localId = javaType.localId().map({ args0 -> args0 }).orElse(null),
            psk = javaType.psk().map({ args0 -> args0 }).orElse(null),
            remoteId = javaType.remoteId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
