@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ipsecAuthAlg The authentication algorithm of phase-two negotiation. Valid value: md5 | sha1 | sha256 | sha384 | sha512 |. Default value: sha1
 * @property ipsecEncAlg The encryption algorithm of phase-two negotiation. Valid value: aes | aes192 | aes256 | des | 3des. Default value: aes
 * @property ipsecLifetime The SA lifecycle as the result of phase-two negotiation. The valid value is [0, 86400], the unit is second and the default value is 86400.
 * @property ipsecPfs The Diffie-Hellman key exchange algorithm used by phase-two negotiation. Valid value: group1 | group2 | group5 | group14 | group24| disabled. Default value: group2
 */
public data class GatewayVpnAttachmentIpsecConfig(
    public val ipsecAuthAlg: String? = null,
    public val ipsecEncAlg: String? = null,
    public val ipsecLifetime: Int? = null,
    public val ipsecPfs: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GatewayVpnAttachmentIpsecConfig): GatewayVpnAttachmentIpsecConfig = GatewayVpnAttachmentIpsecConfig(
            ipsecAuthAlg = javaType.ipsecAuthAlg().map({ args0 -> args0 }).orElse(null),
            ipsecEncAlg = javaType.ipsecEncAlg().map({ args0 -> args0 }).orElse(null),
            ipsecLifetime = javaType.ipsecLifetime().map({ args0 -> args0 }).orElse(null),
            ipsecPfs = javaType.ipsecPfs().map({ args0 -> args0 }).orElse(null),
        )
    }
}
