@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createTime
 * @property customerGatewayId Use the VPN customer gateway ID as the search key.
 * @property effectImmediately
 * @property enableDpd Wether enable Dpd detection.
 * @property enableNatTraversal enable nat traversal.
 * @property enableTunnelsBgp Enable tunnel bgp.
 * @property id ID of the VPN connection.
 * @property ikeConfigs The ike_config mapping supports the following:
 * @property ipsecConfigs The ipsec_config mapping supports the following:
 * @property localSubnet The local subnet of the VPN connection.
 * @property name The name of the VPN connection.
 * @property remoteSubnet The remote subnet of the VPN connection.
 * @property status The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
 * @property tunnelOptionsSpecifications The tunnel_options_specification supports the following:
 * @property vcoHealthChecks
 * @property vpnBgpConfigs The vpn_bgp_config mapping supports the following:
 * @property vpnGatewayId Use the VPN gateway ID as the search key.
 */
public data class GetConnectionsConnection(
    public val createTime: String,
    public val customerGatewayId: String,
    public val effectImmediately: Boolean,
    public val enableDpd: Boolean,
    public val enableNatTraversal: Boolean,
    public val enableTunnelsBgp: Boolean,
    public val id: String,
    public val ikeConfigs: List<GetConnectionsConnectionIkeConfig>? = null,
    public val ipsecConfigs: List<GetConnectionsConnectionIpsecConfig>? = null,
    public val localSubnet: String,
    public val name: String,
    public val remoteSubnet: String,
    public val status: String,
    public val tunnelOptionsSpecifications: List<GetConnectionsConnectionTunnelOptionsSpecification>,
    public val vcoHealthChecks: List<GetConnectionsConnectionVcoHealthCheck>? = null,
    public val vpnBgpConfigs: List<GetConnectionsConnectionVpnBgpConfig>? = null,
    public val vpnGatewayId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetConnectionsConnection): GetConnectionsConnection = GetConnectionsConnection(
            createTime = javaType.createTime(),
            customerGatewayId = javaType.customerGatewayId(),
            effectImmediately = javaType.effectImmediately(),
            enableDpd = javaType.enableDpd(),
            enableNatTraversal = javaType.enableNatTraversal(),
            enableTunnelsBgp = javaType.enableTunnelsBgp(),
            id = javaType.id(),
            ikeConfigs = javaType.ikeConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetConnectionsConnectionIkeConfig.Companion.toKotlin(args0)
                })
            }),
            ipsecConfigs = javaType.ipsecConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetConnectionsConnectionIpsecConfig.Companion.toKotlin(args0)
                })
            }),
            localSubnet = javaType.localSubnet(),
            name = javaType.name(),
            remoteSubnet = javaType.remoteSubnet(),
            status = javaType.status(),
            tunnelOptionsSpecifications = javaType.tunnelOptionsSpecifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetConnectionsConnectionTunnelOptionsSpecification.Companion.toKotlin(args0)
                })
            }),
            vcoHealthChecks = javaType.vcoHealthChecks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetConnectionsConnectionVcoHealthCheck.Companion.toKotlin(args0)
                })
            }),
            vpnBgpConfigs = javaType.vpnBgpConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetConnectionsConnectionVpnBgpConfig.Companion.toKotlin(args0)
                })
            }),
            vpnGatewayId = javaType.vpnGatewayId(),
        )
    }
}
