@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ikeAuthAlg IKE auth Algorithm.
 * @property ikeEncAlg IKE encript algorithm.
 * @property ikeLifetime IKE lifetime.
 * @property ikeLocalId The identification of the VPN gateway.
 * @property ikeMode IKE Mode.
 * @property ikePfs DH Group.
 * @property ikeRemoteId The identification of the customer gateway.
 * @property ikeVersion IKE Version.
 * @property psk Preshared secret key.
 */
public data class GetConnectionsConnectionIkeConfig(
    public val ikeAuthAlg: String? = null,
    public val ikeEncAlg: String? = null,
    public val ikeLifetime: Int? = null,
    public val ikeLocalId: String? = null,
    public val ikeMode: String? = null,
    public val ikePfs: String? = null,
    public val ikeRemoteId: String? = null,
    public val ikeVersion: String? = null,
    public val psk: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetConnectionsConnectionIkeConfig): GetConnectionsConnectionIkeConfig = GetConnectionsConnectionIkeConfig(
            ikeAuthAlg = javaType.ikeAuthAlg().map({ args0 -> args0 }).orElse(null),
            ikeEncAlg = javaType.ikeEncAlg().map({ args0 -> args0 }).orElse(null),
            ikeLifetime = javaType.ikeLifetime().map({ args0 -> args0 }).orElse(null),
            ikeLocalId = javaType.ikeLocalId().map({ args0 -> args0 }).orElse(null),
            ikeMode = javaType.ikeMode().map({ args0 -> args0 }).orElse(null),
            ikePfs = javaType.ikePfs().map({ args0 -> args0 }).orElse(null),
            ikeRemoteId = javaType.ikeRemoteId().map({ args0 -> args0 }).orElse(null),
            ikeVersion = javaType.ikeVersion().map({ args0 -> args0 }).orElse(null),
            psk = javaType.psk().map({ args0 -> args0 }).orElse(null),
        )
    }
}
