@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property customerGatewayId Use the VPN customer gateway ID as the search key.
 * @property enableDpd Wether enable Dpd detection.
 * @property enableNatTraversal enable nat traversal.
 * @property internetIp
 * @property role The role of Tunnel.
 * @property state
 * @property status The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
 * @property tunnelBgpConfig The bgp config of Tunnel.
 * @property tunnelId
 * @property tunnelIkeConfig The configuration of Phase 1 negotiations in Tunnel.
 * @property tunnelIpsecConfig IPsec configuration in Tunnel.
 * @property zoneNo
 */
public data class GetConnectionsConnectionTunnelOptionsSpecification(
    public val customerGatewayId: String,
    public val enableDpd: Boolean,
    public val enableNatTraversal: Boolean,
    public val internetIp: String,
    public val role: String,
    public val state: String,
    public val status: String,
    public val tunnelBgpConfig: GetConnectionsConnectionTunnelOptionsSpecificationTunnelBgpConfig,
    public val tunnelId: String,
    public val tunnelIkeConfig: GetConnectionsConnectionTunnelOptionsSpecificationTunnelIkeConfig,
    public val tunnelIpsecConfig: GetConnectionsConnectionTunnelOptionsSpecificationTunnelIpsecConfig,
    public val zoneNo: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetConnectionsConnectionTunnelOptionsSpecification): GetConnectionsConnectionTunnelOptionsSpecification =
            GetConnectionsConnectionTunnelOptionsSpecification(
                customerGatewayId = javaType.customerGatewayId(),
                enableDpd = javaType.enableDpd(),
                enableNatTraversal = javaType.enableNatTraversal(),
                internetIp = javaType.internetIp(),
                role = javaType.role(),
                state = javaType.state(),
                status = javaType.status(),
                tunnelBgpConfig = javaType.tunnelBgpConfig().let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetConnectionsConnectionTunnelOptionsSpecificationTunnelBgpConfig.Companion.toKotlin(args0)
                }),
                tunnelId = javaType.tunnelId(),
                tunnelIkeConfig = javaType.tunnelIkeConfig().let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetConnectionsConnectionTunnelOptionsSpecificationTunnelIkeConfig.Companion.toKotlin(args0)
                }),
                tunnelIpsecConfig = javaType.tunnelIpsecConfig().let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetConnectionsConnectionTunnelOptionsSpecificationTunnelIpsecConfig.Companion.toKotlin(args0)
                }),
                zoneNo = javaType.zoneNo(),
            )
    }
}
