@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bgpStatus
 * @property localAsn Local asn.
 * @property localBgpIp Local bgp IP.
 * @property peerAsn The counterpart autonomous system number.
 * @property peerBgpIp The BGP address on the other side.
 * @property tunnelCidr BGP Tunnel CIDR.
 */
public data class GetConnectionsConnectionTunnelOptionsSpecificationTunnelBgpConfig(
    public val bgpStatus: String,
    public val localAsn: String,
    public val localBgpIp: String,
    public val peerAsn: String,
    public val peerBgpIp: String,
    public val tunnelCidr: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetConnectionsConnectionTunnelOptionsSpecificationTunnelBgpConfig): GetConnectionsConnectionTunnelOptionsSpecificationTunnelBgpConfig =
            GetConnectionsConnectionTunnelOptionsSpecificationTunnelBgpConfig(
                bgpStatus = javaType.bgpStatus(),
                localAsn = javaType.localAsn(),
                localBgpIp = javaType.localBgpIp(),
                peerAsn = javaType.peerAsn(),
                peerBgpIp = javaType.peerBgpIp(),
                tunnelCidr = javaType.tunnelCidr(),
            )
    }
}
