@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ikeAuthAlg IKE auth Algorithm.
 * @property ikeEncAlg IKE encript algorithm.
 * @property ikeLifetime IKE lifetime.
 * @property ikeMode IKE Mode.
 * @property ikePfs DH Group.
 * @property ikeVersion IKE Version.
 * @property localId The local Id.
 * @property psk Preshared secret key.
 * @property remoteId Remote ID.
 */
public data class GetConnectionsConnectionTunnelOptionsSpecificationTunnelIkeConfig(
    public val ikeAuthAlg: String,
    public val ikeEncAlg: String,
    public val ikeLifetime: Int,
    public val ikeMode: String,
    public val ikePfs: String,
    public val ikeVersion: String,
    public val localId: String,
    public val psk: String,
    public val remoteId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetConnectionsConnectionTunnelOptionsSpecificationTunnelIkeConfig): GetConnectionsConnectionTunnelOptionsSpecificationTunnelIkeConfig =
            GetConnectionsConnectionTunnelOptionsSpecificationTunnelIkeConfig(
                ikeAuthAlg = javaType.ikeAuthAlg(),
                ikeEncAlg = javaType.ikeEncAlg(),
                ikeLifetime = javaType.ikeLifetime(),
                ikeMode = javaType.ikeMode(),
                ikePfs = javaType.ikePfs(),
                ikeVersion = javaType.ikeVersion(),
                localId = javaType.localId(),
                psk = javaType.psk(),
                remoteId = javaType.remoteId(),
            )
    }
}
