@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dip The destination ip address.
 * @property enable The health check on status. Valid values: `true`, `false`.
 * @property interval The time interval between health checks.
 * @property retry The number of retries for health checks issued.
 * @property sip The source ip address.
 * @property status The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
 */
public data class GetConnectionsConnectionVcoHealthCheck(
    public val dip: String? = null,
    public val enable: String? = null,
    public val interval: Int? = null,
    public val retry: Int? = null,
    public val sip: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetConnectionsConnectionVcoHealthCheck): GetConnectionsConnectionVcoHealthCheck = GetConnectionsConnectionVcoHealthCheck(
            dip = javaType.dip().map({ args0 -> args0 }).orElse(null),
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            retry = javaType.retry().map({ args0 -> args0 }).orElse(null),
            sip = javaType.sip().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
