@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authKey The authentication keys for BGP routing protocols.
 * @property localAsn Local asn.
 * @property localBgpIp Local bgp IP.
 * @property peerAsn The counterpart autonomous system number.
 * @property peerBgpIp The BGP address on the other side.
 * @property status The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
 * @property tunnelCidr BGP Tunnel CIDR.
 */
public data class GetConnectionsConnectionVpnBgpConfig(
    public val authKey: String? = null,
    public val localAsn: Int? = null,
    public val localBgpIp: String? = null,
    public val peerAsn: Int? = null,
    public val peerBgpIp: String? = null,
    public val status: String? = null,
    public val tunnelCidr: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetConnectionsConnectionVpnBgpConfig): GetConnectionsConnectionVpnBgpConfig = GetConnectionsConnectionVpnBgpConfig(
            authKey = javaType.authKey().map({ args0 -> args0 }).orElse(null),
            localAsn = javaType.localAsn().map({ args0 -> args0 }).orElse(null),
            localBgpIp = javaType.localBgpIp().map({ args0 -> args0 }).orElse(null),
            peerAsn = javaType.peerAsn().map({ args0 -> args0 }).orElse(null),
            peerBgpIp = javaType.peerBgpIp().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tunnelCidr = javaType.tunnelCidr().map({ args0 -> args0 }).orElse(null),
        )
    }
}
