@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getConnections.
 * @property connections A list of VPN connections. Each element contains the following attributes:
 * @property customerGatewayId The ID of the customer gateway in Tunnel.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids (Optional) IDs of the VPN connections.
 * @property nameRegex
 * @property names (Optional) names of the VPN connections.
 * @property outputFile
 * @property vpnGatewayId ID of the VPN gateway.
 */
public data class GetConnectionsResult(
    public val connections: List<GetConnectionsConnection>,
    public val customerGatewayId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val vpnGatewayId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetConnectionsResult): GetConnectionsResult = GetConnectionsResult(
            connections = javaType.connections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetConnectionsConnection.Companion.toKotlin(args0)
                })
            }),
            customerGatewayId = javaType.customerGatewayId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            vpnGatewayId = javaType.vpnGatewayId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
