@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property asn The autonomous system number of the local data center gateway device of the VPN customer gateway.
 * @property createTime The creation time of the VPN customer gateway.
 * @property description The description of the VPN customer gateway.
 * @property id ID of the VPN customer gateway .
 * @property ipAddress The ip address of the VPN customer gateway.
 * @property name The name of the VPN customer gateway.
 */
public data class GetCustomerGatewaysGateway(
    public val asn: Int,
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val ipAddress: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetCustomerGatewaysGateway): GetCustomerGatewaysGateway = GetCustomerGatewaysGateway(
            asn = javaType.asn(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            ipAddress = javaType.ipAddress(),
            name = javaType.name(),
        )
    }
}
