@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCustomerGateways.
 * @property gateways A list of VPN customer gateways. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids IDs of VPN customer gateway.
 * @property nameRegex
 * @property names names of VPN customer gateway.
 * @property outputFile
 */
public data class GetCustomerGatewaysResult(
    public val gateways: List<GetCustomerGatewaysGateway>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetCustomerGatewaysResult): GetCustomerGatewaysResult = GetCustomerGatewaysResult(
            gateways = javaType.gateways().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetCustomerGatewaysGateway.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
