@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGatewayVcoRoutes.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property routeEntryType
 * @property routes
 * @property status
 * @property vpnConnectionId
 */
public data class GetGatewayVcoRoutesResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val routeEntryType: String? = null,
    public val routes: List<GetGatewayVcoRoutesRoute>,
    public val status: String? = null,
    public val vpnConnectionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetGatewayVcoRoutesResult): GetGatewayVcoRoutesResult = GetGatewayVcoRoutesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            routeEntryType = javaType.routeEntryType().map({ args0 -> args0 }).orElse(null),
            routes = javaType.routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetGatewayVcoRoutesRoute.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            vpnConnectionId = javaType.vpnConnectionId(),
        )
    }
}
