@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property asPath List of autonomous system numbers through which BGP routing entries pass.
 * @property createTime The creation time of the VPN destination route.
 * @property id The ID of the Vpn Gateway Vco Routes.
 * @property nextHop The next hop of the destination route.
 * @property routeDest The destination network segment of the destination route.
 * @property source The source CIDR block of the destination route.
 * @property status The status of the vpn route entry.
 * @property vpnConnectionId The id of the vpn connection.
 * @property weight The weight value of the destination route.
 */
public data class GetGatewayVcoRoutesRoute(
    public val asPath: String,
    public val createTime: String,
    public val id: String,
    public val nextHop: String,
    public val routeDest: String,
    public val source: String,
    public val status: String,
    public val vpnConnectionId: String,
    public val weight: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetGatewayVcoRoutesRoute): GetGatewayVcoRoutesRoute = GetGatewayVcoRoutesRoute(
            asPath = javaType.asPath(),
            createTime = javaType.createTime(),
            id = javaType.id(),
            nextHop = javaType.nextHop(),
            routeDest = javaType.routeDest(),
            source = javaType.source(),
            status = javaType.status(),
            vpnConnectionId = javaType.vpnConnectionId(),
            weight = javaType.weight(),
        )
    }
}
