@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bgpConfigs The configurations of the BGP routing protocol.
 * @property connectionStatus The status of the IPsec-VPN connection.
 * @property createTime The creation time of the resource.
 * @property customerGatewayId The ID of the customer gateway.
 * @property effectImmediately Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
 * @property healthCheckConfigs The health check configurations.
 * @property id The ID of the Vpn Attachment.
 * @property ikeConfigs Configuration negotiated in the second stage.
 * @property internetIp The internet ip of the resource. The alicloud.cen.TransitRouterVpnAttachment resource will not have a value until after it is created.
 * @property ipsecConfigs The configuration of Phase 2 negotiations.
 * @property localSubnet The CIDR block of the virtual private cloud (VPC).
 * @property networkType The network type.
 * @property remoteSubnet The CIDR block of the on-premises data center.
 * @property status The status of the resource.
 * @property vpnAttachmentName The name of the IPsec-VPN connection.
 * @property vpnConnectionId The first ID of the resource.
 */
public data class GetGatewayVpnAttachmentsAttachment(
    public val bgpConfigs: List<GetGatewayVpnAttachmentsAttachmentBgpConfig>,
    public val connectionStatus: String,
    public val createTime: String,
    public val customerGatewayId: String,
    public val effectImmediately: Boolean,
    public val healthCheckConfigs: List<GetGatewayVpnAttachmentsAttachmentHealthCheckConfig>,
    public val id: String,
    public val ikeConfigs: List<GetGatewayVpnAttachmentsAttachmentIkeConfig>,
    public val internetIp: String,
    public val ipsecConfigs: List<GetGatewayVpnAttachmentsAttachmentIpsecConfig>,
    public val localSubnet: String,
    public val networkType: String,
    public val remoteSubnet: String,
    public val status: String,
    public val vpnAttachmentName: String,
    public val vpnConnectionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetGatewayVpnAttachmentsAttachment): GetGatewayVpnAttachmentsAttachment = GetGatewayVpnAttachmentsAttachment(
            bgpConfigs = javaType.bgpConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetGatewayVpnAttachmentsAttachmentBgpConfig.Companion.toKotlin(args0)
                })
            }),
            connectionStatus = javaType.connectionStatus(),
            createTime = javaType.createTime(),
            customerGatewayId = javaType.customerGatewayId(),
            effectImmediately = javaType.effectImmediately(),
            healthCheckConfigs = javaType.healthCheckConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetGatewayVpnAttachmentsAttachmentHealthCheckConfig.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ikeConfigs = javaType.ikeConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetGatewayVpnAttachmentsAttachmentIkeConfig.Companion.toKotlin(args0)
                })
            }),
            internetIp = javaType.internetIp(),
            ipsecConfigs = javaType.ipsecConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetGatewayVpnAttachmentsAttachmentIpsecConfig.Companion.toKotlin(args0)
                })
            }),
            localSubnet = javaType.localSubnet(),
            networkType = javaType.networkType(),
            remoteSubnet = javaType.remoteSubnet(),
            status = javaType.status(),
            vpnAttachmentName = javaType.vpnAttachmentName(),
            vpnConnectionId = javaType.vpnConnectionId(),
        )
    }
}
