@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property localAsn The ASN on the Alibaba Cloud side.
 * @property localBgpIp The BGP IP address on the Alibaba Cloud side.
 * @property status The negotiation status of the BGP routing protocol.
 * @property tunnelCidr The CIDR block of the IPsec tunnel. The CIDR block belongs to 169.254.0.0/16. The mask of the CIDR block is 30 bits in length.
 */
public data class GetGatewayVpnAttachmentsAttachmentBgpConfig(
    public val localAsn: String,
    public val localBgpIp: String,
    public val status: String,
    public val tunnelCidr: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetGatewayVpnAttachmentsAttachmentBgpConfig): GetGatewayVpnAttachmentsAttachmentBgpConfig = GetGatewayVpnAttachmentsAttachmentBgpConfig(
            localAsn = javaType.localAsn(),
            localBgpIp = javaType.localBgpIp(),
            status = javaType.status(),
            tunnelCidr = javaType.tunnelCidr(),
        )
    }
}
