@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dip The destination IP address.
 * @property enable Specifies whether to enable health checks.
 * @property interval The interval between two consecutive health checks. Unit: seconds.
 * @property policy Whether to revoke the published route when the health check fails.
 * @property retry The maximum number of health check retries.
 * @property sip The source IP address.
 * @property status The status of the health check.
 */
public data class GetGatewayVpnAttachmentsAttachmentHealthCheckConfig(
    public val dip: String,
    public val enable: Boolean,
    public val interval: Int,
    public val policy: String,
    public val retry: Int,
    public val sip: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetGatewayVpnAttachmentsAttachmentHealthCheckConfig): GetGatewayVpnAttachmentsAttachmentHealthCheckConfig =
            GetGatewayVpnAttachmentsAttachmentHealthCheckConfig(
                dip = javaType.dip(),
                enable = javaType.enable(),
                interval = javaType.interval(),
                policy = javaType.policy(),
                retry = javaType.retry(),
                sip = javaType.sip(),
                status = javaType.status(),
            )
    }
}
