@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ikeAuthAlg The IKE authentication algorithm.
 * @property ikeEncAlg The IKE encryption algorithm.
 * @property ikeLifetime The IKE lifetime. Unit: seconds.
 * @property ikeMode The IKE negotiation mode.
 * @property ikePfs The DH group.
 * @property ikeVersion The version of the IKE protocol.
 * @property localId The local ID, which supports the FQDN and IP formats. The current VPN gateway IP address is selected by default. The alicloud.cen.TransitRouterVpnAttachment resource will not have a value until after it is created.
 * @property psk The pre-shared key.
 * @property remoteId The identifier of the peer. The default value is the IP address of the VPN gateway. The value can be a fully qualified domain name (FQDN) or an IP address.
 */
public data class GetGatewayVpnAttachmentsAttachmentIkeConfig(
    public val ikeAuthAlg: String,
    public val ikeEncAlg: String,
    public val ikeLifetime: String,
    public val ikeMode: String,
    public val ikePfs: String,
    public val ikeVersion: String,
    public val localId: String,
    public val psk: String,
    public val remoteId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetGatewayVpnAttachmentsAttachmentIkeConfig): GetGatewayVpnAttachmentsAttachmentIkeConfig = GetGatewayVpnAttachmentsAttachmentIkeConfig(
            ikeAuthAlg = javaType.ikeAuthAlg(),
            ikeEncAlg = javaType.ikeEncAlg(),
            ikeLifetime = javaType.ikeLifetime(),
            ikeMode = javaType.ikeMode(),
            ikePfs = javaType.ikePfs(),
            ikeVersion = javaType.ikeVersion(),
            localId = javaType.localId(),
            psk = javaType.psk(),
            remoteId = javaType.remoteId(),
        )
    }
}
