@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ipsecAuthAlg The IPsec authentication algorithm.
 * @property ipsecEncAlg The IPsec encryption algorithm.
 * @property ipsecLifetime The IPsec lifetime. Unit: seconds.
 * @property ipsecPfs The DH group.
 */
public data class GetGatewayVpnAttachmentsAttachmentIpsecConfig(
    public val ipsecAuthAlg: String,
    public val ipsecEncAlg: String,
    public val ipsecLifetime: String,
    public val ipsecPfs: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetGatewayVpnAttachmentsAttachmentIpsecConfig): GetGatewayVpnAttachmentsAttachmentIpsecConfig =
            GetGatewayVpnAttachmentsAttachmentIpsecConfig(
                ipsecAuthAlg = javaType.ipsecAuthAlg(),
                ipsecEncAlg = javaType.ipsecEncAlg(),
                ipsecLifetime = javaType.ipsecLifetime(),
                ipsecPfs = javaType.ipsecPfs(),
            )
    }
}
