@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGatewayVpnAttachments.
 * @property attachments
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property status
 * @property vpnGatewayId
 */
public data class GetGatewayVpnAttachmentsResult(
    public val attachments: List<GetGatewayVpnAttachmentsAttachment>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
    @Deprecated(
        message = """
  The parameter 'vpn_gateway_id' has been deprecated from 1.194.0.
  """,
    )
    public val vpnGatewayId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetGatewayVpnAttachmentsResult): GetGatewayVpnAttachmentsResult = GetGatewayVpnAttachmentsResult(
            attachments = javaType.attachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetGatewayVpnAttachmentsAttachment.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            vpnGatewayId = javaType.vpnGatewayId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
