@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGatewayZones.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Zone IDs.
 * @property outputFile
 * @property spec
 * @property zones A list of Zone Entries. Each element contains the following attributes:
 */
public data class GetGatewayZonesResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val spec: String,
    public val zones: List<GetGatewayZonesZone>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetGatewayZonesResult): GetGatewayZonesResult = GetGatewayZonesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            spec = javaType.spec(),
            zones = javaType.zones().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetGatewayZonesZone.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
