@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property autoPropagate Whether to automatically propagate BGP routes to the VPC. Valid values: `true`, `false`.
 * @property businessStatus Limit search to specific business status - valid value is "Normal", "FinancialLocked".
 * @property createTime The creation time of the VPN gateway.
 * @property description The description of the VPN
 * @property disasterRecoveryInternetIp The backup public IP address of the VPN gateway. The second IP address assigned by the system to create an IPsec-VPN connection. This parameter is returned only when the VPN gateway supports the dual-tunnel mode.
 * @property disasterRecoveryVswitchId - The ID of the backup vSwitch to which the VPN gateway is attached.
 * @property enableIpsec Indicates whether the IPsec-VPN feature is enabled.
 * @property enableSsl Whether the ssl function is enabled.
 * @property endTime The expiration time of the VPN gateway.
 * @property id ID of the VPN.
 * @property instanceChargeType The charge type of the VPN gateway.
 * @property internetIp The internet ip of the VPN.
 * @property name The name of the VPN.
 * @property networkType The network type of the VPN gateway.
 * @property resourceGroupId The ID of the resource group.
 * @property specification The Specification of the VPN
 * @property sslConnections Total count of ssl vpn connections.
 * @property sslVpnInternetIp The IP address of the SSL-VPN connection. This parameter is returned only when the VPN gateway is a public VPN gateway and supports only the single-tunnel mode. In addition, the VPN gateway must have the SSL-VPN feature enabled.
 * @property status Limit search to specific status - valid value is "Init", "Provisioning", "Active", "Updating", "Deleting".
 * @property tags The Tag of.
 * @property vpcId Use the VPC ID as the search key.
 * @property vpnType - The VPN gateway type. Value:  Normal (default): Normal type. NationalStandard: National Secret type.
 * @property vswitchId - The ID of the vSwitch to which the VPN gateway is attached.
 */
public data class GetGatewaysGateway(
    public val autoPropagate: String,
    public val businessStatus: String,
    public val createTime: String,
    public val description: String,
    public val disasterRecoveryInternetIp: String,
    public val disasterRecoveryVswitchId: String,
    public val enableIpsec: String,
    public val enableSsl: String,
    public val endTime: String,
    public val id: String,
    public val instanceChargeType: String,
    public val internetIp: String,
    public val name: String,
    public val networkType: String,
    public val resourceGroupId: String,
    public val specification: String,
    public val sslConnections: Int,
    public val sslVpnInternetIp: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
    public val vpnType: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetGatewaysGateway): GetGatewaysGateway = GetGatewaysGateway(
            autoPropagate = javaType.autoPropagate(),
            businessStatus = javaType.businessStatus(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            disasterRecoveryInternetIp = javaType.disasterRecoveryInternetIp(),
            disasterRecoveryVswitchId = javaType.disasterRecoveryVswitchId(),
            enableIpsec = javaType.enableIpsec(),
            enableSsl = javaType.enableSsl(),
            endTime = javaType.endTime(),
            id = javaType.id(),
            instanceChargeType = javaType.instanceChargeType(),
            internetIp = javaType.internetIp(),
            name = javaType.name(),
            networkType = javaType.networkType(),
            resourceGroupId = javaType.resourceGroupId(),
            specification = javaType.specification(),
            sslConnections = javaType.sslConnections(),
            sslVpnInternetIp = javaType.sslVpnInternetIp(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            vpnType = javaType.vpnType(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
