@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGateways.
 * @property businessStatus The business status of the VPN gateway.
 * @property enableIpsec Whether the ipsec function is enabled.
 * @property gateways A list of VPN gateways. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids IDs of the VPN.
 * @property includeReservationData
 * @property nameRegex
 * @property names names of the VPN.
 * @property outputFile
 * @property status The status of the VPN
 * @property vpcId ID of the VPC that the VPN belongs.
 */
public data class GetGatewaysResult(
    public val businessStatus: String? = null,
    @Deprecated(
        message = """
  Field 'enable_ipsec' has been deprecated from provider version 1.193.0 and it will be removed in
      the future version.
  """,
    )
    public val enableIpsec: Boolean? = null,
    public val gateways: List<GetGatewaysGateway>,
    public val id: String,
    public val ids: List<String>,
    public val includeReservationData: Boolean? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.GetGatewaysResult): GetGatewaysResult = GetGatewaysResult(
            businessStatus = javaType.businessStatus().map({ args0 -> args0 }).orElse(null),
            enableIpsec = javaType.enableIpsec().map({ args0 -> args0 }).orElse(null),
            gateways = javaType.gateways().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpn.kotlin.outputs.GetGatewaysGateway.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            includeReservationData = javaType.includeReservationData().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
