@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ikeAuthAlg The authentication algorithm that is used in Phase 1 negotiations. Default value: `sha1`.
 * @property ikeEncAlg The encryption algorithm that is used in Phase 1 negotiations. Default value: `aes`.
 * @property ikeLifetime IkeLifetime: the SA lifetime determined by Phase 1 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
 * @property ikeMode The IKE negotiation mode. Default value: `main`.
 * @property ikePfs The Diffie-Hellman key exchange algorithm that is used in Phase 1 negotiations. Default value: `group2`.
 * @property ikeVersion The IKE version. Valid values: `ikev1` and `ikev2`. Default value: `ikev2`.
 * @property localId The identifier of the IPsec server. The value can be a fully qualified domain name (FQDN) or an IP address. The default value is the public IP address of the VPN gateway.
 * @property remoteId The identifier of the customer gateway. The value can be an FQDN or an IP address. By default, this parameter is not specified.
 */
public data class IpsecServerIkeConfig(
    public val ikeAuthAlg: String? = null,
    public val ikeEncAlg: String? = null,
    public val ikeLifetime: Int? = null,
    public val ikeMode: String? = null,
    public val ikePfs: String? = null,
    public val ikeVersion: String? = null,
    public val localId: String? = null,
    public val remoteId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.IpsecServerIkeConfig): IpsecServerIkeConfig = IpsecServerIkeConfig(
            ikeAuthAlg = javaType.ikeAuthAlg().map({ args0 -> args0 }).orElse(null),
            ikeEncAlg = javaType.ikeEncAlg().map({ args0 -> args0 }).orElse(null),
            ikeLifetime = javaType.ikeLifetime().map({ args0 -> args0 }).orElse(null),
            ikeMode = javaType.ikeMode().map({ args0 -> args0 }).orElse(null),
            ikePfs = javaType.ikePfs().map({ args0 -> args0 }).orElse(null),
            ikeVersion = javaType.ikeVersion().map({ args0 -> args0 }).orElse(null),
            localId = javaType.localId().map({ args0 -> args0 }).orElse(null),
            remoteId = javaType.remoteId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
