@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ipsecAuthAlg The authentication algorithm that is used in Phase 2 negotiations. Default value: `sha1`.
 * @property ipsecEncAlg The encryption algorithm that is used in Phase 2 negotiations. Default value: `aes`.
 * @property ipsecLifetime The SA lifetime determined by Phase 2 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
 * @property ipsecPfs Forwards packets of all protocols. The Diffie-Hellman key exchange algorithm used in Phase 2 negotiations. Default value: `group2`.
 */
public data class IpsecServerIpsecConfig(
    public val ipsecAuthAlg: String? = null,
    public val ipsecEncAlg: String? = null,
    public val ipsecLifetime: Int? = null,
    public val ipsecPfs: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpn.outputs.IpsecServerIpsecConfig): IpsecServerIpsecConfig = IpsecServerIpsecConfig(
            ipsecAuthAlg = javaType.ipsecAuthAlg().map({ args0 -> args0 }).orElse(null),
            ipsecEncAlg = javaType.ipsecEncAlg().map({ args0 -> args0 }).orElse(null),
            ipsecLifetime = javaType.ipsecLifetime().map({ args0 -> args0 }).orElse(null),
            ipsecPfs = javaType.ipsecPfs().map({ args0 -> args0 }).orElse(null),
        )
    }
}
