@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.waf.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Certificate].
 */
@PulumiTagMarker
public class CertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CertificateArgs = CertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CertificateArgsBuilder.() -> Unit) {
        val builder = CertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Certificate {
        val builtJavaResource = com.pulumi.alicloud.waf.Certificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Certificate(builtJavaResource)
    }
}

/**
 * Provides a WAF Certificate resource.
 * For information about WAF Certificate and how to use it, see [What is Certificate](https://www.alibabacloud.com/help/doc-detail/28517.htm).
 * > **NOTE:** Available in v1.135.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.waf.Certificate("default", {
 *     certificateName: "your_certificate_name",
 *     instanceId: "your_instance_id",
 *     domain: "your_domain_name",
 *     privateKey: "your_private_key",
 *     certificate: "your_certificate",
 * });
 * const default2 = new alicloud.waf.Certificate("default2", {
 *     instanceId: "your_instance_id",
 *     domain: "your_domain_name",
 *     certificateId: "your_certificate_id",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.waf.Certificate("default",
 *     certificate_name="your_certificate_name",
 *     instance_id="your_instance_id",
 *     domain="your_domain_name",
 *     private_key="your_private_key",
 *     certificate="your_certificate")
 * default2 = alicloud.waf.Certificate("default2",
 *     instance_id="your_instance_id",
 *     domain="your_domain_name",
 *     certificate_id="your_certificate_id")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Waf.Certificate("default", new()
 *     {
 *         CertificateName = "your_certificate_name",
 *         InstanceId = "your_instance_id",
 *         Domain = "your_domain_name",
 *         PrivateKey = "your_private_key",
 *         CertificateContents = "your_certificate",
 *     });
 *     var default2 = new AliCloud.Waf.Certificate("default2", new()
 *     {
 *         InstanceId = "your_instance_id",
 *         Domain = "your_domain_name",
 *         CertificateId = "your_certificate_id",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := waf.NewCertificate(ctx, "default", &waf.CertificateArgs{
 * 			CertificateName: pulumi.String("your_certificate_name"),
 * 			InstanceId:      pulumi.String("your_instance_id"),
 * 			Domain:          pulumi.String("your_domain_name"),
 * 			PrivateKey:      pulumi.String("your_private_key"),
 * 			Certificate:     pulumi.String("your_certificate"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = waf.NewCertificate(ctx, "default2", &waf.CertificateArgs{
 * 			InstanceId:    pulumi.String("your_instance_id"),
 * 			Domain:        pulumi.String("your_domain_name"),
 * 			CertificateId: pulumi.String("your_certificate_id"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.waf.Certificate;
 * import com.pulumi.alicloud.waf.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Certificate("default", CertificateArgs.builder()
 *             .certificateName("your_certificate_name")
 *             .instanceId("your_instance_id")
 *             .domain("your_domain_name")
 *             .privateKey("your_private_key")
 *             .certificate("your_certificate")
 *             .build());
 *         var default2 = new Certificate("default2", CertificateArgs.builder()
 *             .instanceId("your_instance_id")
 *             .domain("your_domain_name")
 *             .certificateId("your_certificate_id")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:waf:Certificate
 *     properties:
 *       certificateName: your_certificate_name
 *       instanceId: your_instance_id
 *       domain: your_domain_name
 *       privateKey: your_private_key
 *       certificate: your_certificate
 *   default2:
 *     type: alicloud:waf:Certificate
 *     properties:
 *       instanceId: your_instance_id
 *       domain: your_domain_name
 *       certificateId: your_certificate_id
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * WAF Certificate can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:waf/certificate:Certificate example <instance_id>:<domain>:<certificate_id>
 * ```
 */
public class Certificate internal constructor(
    override val javaResource: com.pulumi.alicloud.waf.Certificate,
) : KotlinCustomResource(javaResource, CertificateMapper) {
    /**
     * Certificate file content.
     */
    public val certificate: Output<String>?
        get() = javaResource.certificate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The certificate id is automatically generated when you upload your certificate content.**NOTE:** you can also use Certificate ID saved in SSL.
     */
    public val certificateId: Output<String>
        get() = javaResource.certificateId().applyValue({ args0 -> args0 })

    /**
     * Certificate file name.
     */
    public val certificateName: Output<String>
        get() = javaResource.certificateName().applyValue({ args0 -> args0 })

    /**
     * The domain that you want to add to WAF.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * The ID of the WAF instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The private key.
     */
    public val privateKey: Output<String>?
        get() = javaResource.privateKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object CertificateMapper : ResourceMapper<Certificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.waf.Certificate::class == javaResource::class

    override fun map(javaResource: Resource): Certificate = Certificate(
        javaResource as
            com.pulumi.alicloud.waf.Certificate,
    )
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Certificate].
 */
public suspend fun certificate(name: String, block: suspend CertificateResourceBuilder.() -> Unit): Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun certificate(name: String): Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
