@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.waf.kotlin

import com.pulumi.alicloud.waf.CertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a WAF Certificate resource.
 * For information about WAF Certificate and how to use it, see [What is Certificate](https://www.alibabacloud.com/help/doc-detail/28517.htm).
 * > **NOTE:** Available in v1.135.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.waf.Certificate("default", {
 *     certificateName: "your_certificate_name",
 *     instanceId: "your_instance_id",
 *     domain: "your_domain_name",
 *     privateKey: "your_private_key",
 *     certificate: "your_certificate",
 * });
 * const default2 = new alicloud.waf.Certificate("default2", {
 *     instanceId: "your_instance_id",
 *     domain: "your_domain_name",
 *     certificateId: "your_certificate_id",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.waf.Certificate("default",
 *     certificate_name="your_certificate_name",
 *     instance_id="your_instance_id",
 *     domain="your_domain_name",
 *     private_key="your_private_key",
 *     certificate="your_certificate")
 * default2 = alicloud.waf.Certificate("default2",
 *     instance_id="your_instance_id",
 *     domain="your_domain_name",
 *     certificate_id="your_certificate_id")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Waf.Certificate("default", new()
 *     {
 *         CertificateName = "your_certificate_name",
 *         InstanceId = "your_instance_id",
 *         Domain = "your_domain_name",
 *         PrivateKey = "your_private_key",
 *         CertificateContents = "your_certificate",
 *     });
 *     var default2 = new AliCloud.Waf.Certificate("default2", new()
 *     {
 *         InstanceId = "your_instance_id",
 *         Domain = "your_domain_name",
 *         CertificateId = "your_certificate_id",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := waf.NewCertificate(ctx, "default", &waf.CertificateArgs{
 * 			CertificateName: pulumi.String("your_certificate_name"),
 * 			InstanceId:      pulumi.String("your_instance_id"),
 * 			Domain:          pulumi.String("your_domain_name"),
 * 			PrivateKey:      pulumi.String("your_private_key"),
 * 			Certificate:     pulumi.String("your_certificate"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = waf.NewCertificate(ctx, "default2", &waf.CertificateArgs{
 * 			InstanceId:    pulumi.String("your_instance_id"),
 * 			Domain:        pulumi.String("your_domain_name"),
 * 			CertificateId: pulumi.String("your_certificate_id"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.waf.Certificate;
 * import com.pulumi.alicloud.waf.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Certificate("default", CertificateArgs.builder()
 *             .certificateName("your_certificate_name")
 *             .instanceId("your_instance_id")
 *             .domain("your_domain_name")
 *             .privateKey("your_private_key")
 *             .certificate("your_certificate")
 *             .build());
 *         var default2 = new Certificate("default2", CertificateArgs.builder()
 *             .instanceId("your_instance_id")
 *             .domain("your_domain_name")
 *             .certificateId("your_certificate_id")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:waf:Certificate
 *     properties:
 *       certificateName: your_certificate_name
 *       instanceId: your_instance_id
 *       domain: your_domain_name
 *       privateKey: your_private_key
 *       certificate: your_certificate
 *   default2:
 *     type: alicloud:waf:Certificate
 *     properties:
 *       instanceId: your_instance_id
 *       domain: your_domain_name
 *       certificateId: your_certificate_id
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * WAF Certificate can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:waf/certificate:Certificate example <instance_id>:<domain>:<certificate_id>
 * ```
 * @property certificate Certificate file content.
 * @property certificateId The certificate id is automatically generated when you upload your certificate content.**NOTE:** you can also use Certificate ID saved in SSL.
 * @property certificateName Certificate file name.
 * @property domain The domain that you want to add to WAF.
 * @property instanceId The ID of the WAF instance.
 * @property privateKey The private key.
 */
public data class CertificateArgs(
    public val certificate: Output<String>? = null,
    public val certificateId: Output<String>? = null,
    public val certificateName: Output<String>? = null,
    public val domain: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val privateKey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.waf.CertificateArgs> {
    override fun toJava(): com.pulumi.alicloud.waf.CertificateArgs =
        com.pulumi.alicloud.waf.CertificateArgs.builder()
            .certificate(certificate?.applyValue({ args0 -> args0 }))
            .certificateId(certificateId?.applyValue({ args0 -> args0 }))
            .certificateName(certificateName?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .privateKey(privateKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateArgs].
 */
@PulumiTagMarker
public class CertificateArgsBuilder internal constructor() {
    private var certificate: Output<String>? = null

    private var certificateId: Output<String>? = null

    private var certificateName: Output<String>? = null

    private var domain: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var privateKey: Output<String>? = null

    /**
     * @param value Certificate file content.
     */
    @JvmName("skshvckgetvvrewt")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value The certificate id is automatically generated when you upload your certificate content.**NOTE:** you can also use Certificate ID saved in SSL.
     */
    @JvmName("nrsqrsmjweuaobpw")
    public suspend fun certificateId(`value`: Output<String>) {
        this.certificateId = value
    }

    /**
     * @param value Certificate file name.
     */
    @JvmName("fjdnkdqsefgnwmmg")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value The domain that you want to add to WAF.
     */
    @JvmName("huwolkxahogljssp")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The ID of the WAF instance.
     */
    @JvmName("eayqflxjcyfcjhdu")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The private key.
     */
    @JvmName("aqyukqkjkincyjlf")
    public suspend fun privateKey(`value`: Output<String>) {
        this.privateKey = value
    }

    /**
     * @param value Certificate file content.
     */
    @JvmName("yasdrxpjflytcxud")
    public suspend fun certificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value The certificate id is automatically generated when you upload your certificate content.**NOTE:** you can also use Certificate ID saved in SSL.
     */
    @JvmName("jvsradverwolpyau")
    public suspend fun certificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateId = mapped
    }

    /**
     * @param value Certificate file name.
     */
    @JvmName("ypvrwsytwiqfajty")
    public suspend fun certificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value The domain that you want to add to WAF.
     */
    @JvmName("hrqccqjdvbogokko")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The ID of the WAF instance.
     */
    @JvmName("nqefdaxmbkqdfrew")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The private key.
     */
    @JvmName("hdmvpkeavombgili")
    public suspend fun privateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    internal fun build(): CertificateArgs = CertificateArgs(
        certificate = certificate,
        certificateId = certificateId,
        certificateName = certificateName,
        domain = domain,
        instanceId = instanceId,
        privateKey = privateKey,
    )
}
