@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.waf.kotlin

import com.pulumi.alicloud.waf.kotlin.outputs.DomainLogHeader
import com.pulumi.alicloud.waf.kotlin.outputs.DomainLogHeader.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.alicloud.waf.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * > **DEPRECATED:**  This resource has been deprecated and using alicloud.wafv3.Domain instead.
 * Provides a WAF Domain resource to create domain in the Web Application Firewall.
 * For information about WAF and how to use it, see [What is Alibaba Cloud WAF](https://www.alibabacloud.com/help/doc-detail/28517.htm).
 * > **NOTE:** Available in 1.82.0+ .
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const domain = new alicloud.waf.Domain("domain", {
 *     domainName: "alicloud-provider.cn",
 *     instanceId: "waf-123455",
 *     isAccessProduct: "On",
 *     sourceIps: ["1&#46;1&#46;1&#46;1"],
 *     clusterType: "PhysicalCluster",
 *     http2Ports: ["443"],
 *     httpPorts: ["80"],
 *     httpsPorts: ["443"],
 *     httpToUserIp: "Off",
 *     httpsRedirect: "Off",
 *     loadBalancing: "IpHash",
 *     logHeaders: [{
 *         key: "foo",
 *         value: "http",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * domain = alicloud.waf.Domain("domain",
 *     domain_name="alicloud-provider.cn",
 *     instance_id="waf-123455",
 *     is_access_product="On",
 *     source_ips=["1&#46;1&#46;1&#46;1"],
 *     cluster_type="PhysicalCluster",
 *     http2_ports=["443"],
 *     http_ports=["80"],
 *     https_ports=["443"],
 *     http_to_user_ip="Off",
 *     https_redirect="Off",
 *     load_balancing="IpHash",
 *     log_headers=[{
 *         "key": "foo",
 *         "value": "http",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domain = new AliCloud.Waf.Domain("domain", new()
 *     {
 *         DomainName = "alicloud-provider.cn",
 *         InstanceId = "waf-123455",
 *         IsAccessProduct = "On",
 *         SourceIps = new[]
 *         {
 *             "1.1.1.1",
 *         },
 *         ClusterType = "PhysicalCluster",
 *         Http2Ports = new[]
 *         {
 *             "443",
 *         },
 *         HttpPorts = new[]
 *         {
 *             "80",
 *         },
 *         HttpsPorts = new[]
 *         {
 *             "443",
 *         },
 *         HttpToUserIp = "Off",
 *         HttpsRedirect = "Off",
 *         LoadBalancing = "IpHash",
 *         LogHeaders = new[]
 *         {
 *             new AliCloud.Waf.Inputs.DomainLogHeaderArgs
 *             {
 *                 Key = "foo",
 *                 Value = "http",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := waf.NewDomain(ctx, "domain", &waf.DomainArgs{
 * 			DomainName:      pulumi.String("alicloud-provider.cn"),
 * 			InstanceId:      pulumi.String("waf-123455"),
 * 			IsAccessProduct: pulumi.String("On"),
 * 			SourceIps: pulumi.StringArray{
 * 				pulumi.String("1.1.1.1"),
 * 			},
 * 			ClusterType: pulumi.String("PhysicalCluster"),
 * 			Http2Ports: pulumi.StringArray{
 * 				pulumi.String("443"),
 * 			},
 * 			HttpPorts: pulumi.StringArray{
 * 				pulumi.String("80"),
 * 			},
 * 			HttpsPorts: pulumi.StringArray{
 * 				pulumi.String("443"),
 * 			},
 * 			HttpToUserIp:  pulumi.String("Off"),
 * 			HttpsRedirect: pulumi.String("Off"),
 * 			LoadBalancing: pulumi.String("IpHash"),
 * 			LogHeaders: waf.DomainLogHeaderArray{
 * 				&waf.DomainLogHeaderArgs{
 * 					Key:   pulumi.String("foo"),
 * 					Value: pulumi.String("http"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.waf.Domain;
 * import com.pulumi.alicloud.waf.DomainArgs;
 * import com.pulumi.alicloud.waf.inputs.DomainLogHeaderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domain = new Domain("domain", DomainArgs.builder()
 *             .domainName("alicloud-provider.cn")
 *             .instanceId("waf-123455")
 *             .isAccessProduct("On")
 *             .sourceIps("1.1.1.1")
 *             .clusterType("PhysicalCluster")
 *             .http2Ports(443)
 *             .httpPorts(80)
 *             .httpsPorts(443)
 *             .httpToUserIp("Off")
 *             .httpsRedirect("Off")
 *             .loadBalancing("IpHash")
 *             .logHeaders(DomainLogHeaderArgs.builder()
 *                 .key("foo")
 *                 .value("http")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   domain:
 *     type: alicloud:waf:Domain
 *     properties:
 *       domainName: alicloud-provider.cn
 *       instanceId: waf-123455
 *       isAccessProduct: On
 *       sourceIps:
 *         - 1.1.1.1
 *       clusterType: PhysicalCluster
 *       http2Ports:
 *         - 443
 *       httpPorts:
 *         - 80
 *       httpsPorts:
 *         - 443
 *       httpToUserIp: Off
 *       httpsRedirect: Off
 *       loadBalancing: IpHash
 *       logHeaders:
 *         - key: foo
 *           value: http
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * WAF domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:waf/domain:Domain domain waf-132435:www.domain.com
 * ```
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.alicloud.waf.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * The type of the WAF cluster. Valid values: `PhysicalCluster` and `VirtualCluster`. Default to `PhysicalCluster`.
     */
    public val clusterType: Output<String>?
        get() = javaResource.clusterType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The CNAME record assigned by the WAF instance to the specified domain.
     */
    public val cname: Output<String>
        get() = javaResource.cname().applyValue({ args0 -> args0 })

    /**
     * The connection timeout for WAF exclusive clusters. Unit: seconds.
     */
    public val connectionTime: Output<Int>?
        get() = javaResource.connectionTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Field `domain` has been deprecated from version 1.94.0. Use `domain_name` instead.
     */
    @Deprecated(
        message = """
  Field 'domain' has been deprecated from version 1.94.0. Use 'domain_name' instead.
  """,
    )
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * The domain that you want to add to WAF. The `domain_name` is required when the value of the `domain`  is Empty.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * List of the HTTP 2.0 ports.
     */
    public val http2Ports: Output<List<String>>?
        get() = javaResource.http2Ports().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * List of the HTTP ports.
     */
    public val httpPorts: Output<List<String>>?
        get() = javaResource.httpPorts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Specifies whether to enable the HTTP back-to-origin feature. After this feature is enabled, the WAF instance can use HTTP to forward HTTPS requests to the origin server.
     * By default, port 80 is used to forward the requests to the origin server. Valid values: `On` and `Off`. Default to `Off`.
     */
    public val httpToUserIp: Output<String>?
        get() = javaResource.httpToUserIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of the HTTPS ports.
     */
    public val httpsPorts: Output<List<String>>?
        get() = javaResource.httpsPorts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Specifies whether to redirect HTTP requests as HTTPS requests. Valid values: "On" and `Off`. Default to `Off`.
     */
    public val httpsRedirect: Output<String>?
        get() = javaResource.httpsRedirect().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the WAF instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: `On` and `Off`. Default to `Off`.
     */
    public val isAccessProduct: Output<String>
        get() = javaResource.isAccessProduct().applyValue({ args0 -> args0 })

    /**
     * The load balancing algorithm that is used to forward requests to the origin. Valid values: `IpHash` and `RoundRobin`. Default to `IpHash`.
     */
    public val loadBalancing: Output<String>?
        get() = javaResource.loadBalancing().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
     * * key: The key of label
     * * value: The value of label
     */
    public val logHeaders: Output<List<DomainLogHeader>>?
        get() = javaResource.logHeaders().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The read timeout of a WAF exclusive cluster. Unit: seconds.
     */
    public val readTime: Output<Int>?
        get() = javaResource.readTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the resource group to which the queried domain belongs in Resource Management. By default, no value is specified, indicating that the domain belongs to the default resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * List of the IP address or domain of the origin server to which the specified domain points.
     */
    public val sourceIps: Output<List<String>>?
        get() = javaResource.sourceIps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The timeout period for a WAF exclusive cluster write connection. Unit: seconds.
     */
    public val writeTime: Output<Int>?
        get() = javaResource.writeTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.waf.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.alicloud.waf.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
