@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.waf.kotlin

import com.pulumi.alicloud.waf.DomainArgs.builder
import com.pulumi.alicloud.waf.kotlin.inputs.DomainLogHeaderArgs
import com.pulumi.alicloud.waf.kotlin.inputs.DomainLogHeaderArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * > **DEPRECATED:**  This resource has been deprecated and using alicloud.wafv3.Domain instead.
 * Provides a WAF Domain resource to create domain in the Web Application Firewall.
 * For information about WAF and how to use it, see [What is Alibaba Cloud WAF](https://www.alibabacloud.com/help/doc-detail/28517.htm).
 * > **NOTE:** Available in 1.82.0+ .
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const domain = new alicloud.waf.Domain("domain", {
 *     domainName: "alicloud-provider.cn",
 *     instanceId: "waf-123455",
 *     isAccessProduct: "On",
 *     sourceIps: ["1&#46;1&#46;1&#46;1"],
 *     clusterType: "PhysicalCluster",
 *     http2Ports: ["443"],
 *     httpPorts: ["80"],
 *     httpsPorts: ["443"],
 *     httpToUserIp: "Off",
 *     httpsRedirect: "Off",
 *     loadBalancing: "IpHash",
 *     logHeaders: [{
 *         key: "foo",
 *         value: "http",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * domain = alicloud.waf.Domain("domain",
 *     domain_name="alicloud-provider.cn",
 *     instance_id="waf-123455",
 *     is_access_product="On",
 *     source_ips=["1&#46;1&#46;1&#46;1"],
 *     cluster_type="PhysicalCluster",
 *     http2_ports=["443"],
 *     http_ports=["80"],
 *     https_ports=["443"],
 *     http_to_user_ip="Off",
 *     https_redirect="Off",
 *     load_balancing="IpHash",
 *     log_headers=[{
 *         "key": "foo",
 *         "value": "http",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domain = new AliCloud.Waf.Domain("domain", new()
 *     {
 *         DomainName = "alicloud-provider.cn",
 *         InstanceId = "waf-123455",
 *         IsAccessProduct = "On",
 *         SourceIps = new[]
 *         {
 *             "1.1.1.1",
 *         },
 *         ClusterType = "PhysicalCluster",
 *         Http2Ports = new[]
 *         {
 *             "443",
 *         },
 *         HttpPorts = new[]
 *         {
 *             "80",
 *         },
 *         HttpsPorts = new[]
 *         {
 *             "443",
 *         },
 *         HttpToUserIp = "Off",
 *         HttpsRedirect = "Off",
 *         LoadBalancing = "IpHash",
 *         LogHeaders = new[]
 *         {
 *             new AliCloud.Waf.Inputs.DomainLogHeaderArgs
 *             {
 *                 Key = "foo",
 *                 Value = "http",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := waf.NewDomain(ctx, "domain", &waf.DomainArgs{
 * 			DomainName:      pulumi.String("alicloud-provider.cn"),
 * 			InstanceId:      pulumi.String("waf-123455"),
 * 			IsAccessProduct: pulumi.String("On"),
 * 			SourceIps: pulumi.StringArray{
 * 				pulumi.String("1.1.1.1"),
 * 			},
 * 			ClusterType: pulumi.String("PhysicalCluster"),
 * 			Http2Ports: pulumi.StringArray{
 * 				pulumi.String("443"),
 * 			},
 * 			HttpPorts: pulumi.StringArray{
 * 				pulumi.String("80"),
 * 			},
 * 			HttpsPorts: pulumi.StringArray{
 * 				pulumi.String("443"),
 * 			},
 * 			HttpToUserIp:  pulumi.String("Off"),
 * 			HttpsRedirect: pulumi.String("Off"),
 * 			LoadBalancing: pulumi.String("IpHash"),
 * 			LogHeaders: waf.DomainLogHeaderArray{
 * 				&waf.DomainLogHeaderArgs{
 * 					Key:   pulumi.String("foo"),
 * 					Value: pulumi.String("http"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.waf.Domain;
 * import com.pulumi.alicloud.waf.DomainArgs;
 * import com.pulumi.alicloud.waf.inputs.DomainLogHeaderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domain = new Domain("domain", DomainArgs.builder()
 *             .domainName("alicloud-provider.cn")
 *             .instanceId("waf-123455")
 *             .isAccessProduct("On")
 *             .sourceIps("1.1.1.1")
 *             .clusterType("PhysicalCluster")
 *             .http2Ports(443)
 *             .httpPorts(80)
 *             .httpsPorts(443)
 *             .httpToUserIp("Off")
 *             .httpsRedirect("Off")
 *             .loadBalancing("IpHash")
 *             .logHeaders(DomainLogHeaderArgs.builder()
 *                 .key("foo")
 *                 .value("http")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   domain:
 *     type: alicloud:waf:Domain
 *     properties:
 *       domainName: alicloud-provider.cn
 *       instanceId: waf-123455
 *       isAccessProduct: On
 *       sourceIps:
 *         - 1.1.1.1
 *       clusterType: PhysicalCluster
 *       http2Ports:
 *         - 443
 *       httpPorts:
 *         - 80
 *       httpsPorts:
 *         - 443
 *       httpToUserIp: Off
 *       httpsRedirect: Off
 *       loadBalancing: IpHash
 *       logHeaders:
 *         - key: foo
 *           value: http
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * WAF domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:waf/domain:Domain domain waf-132435:www.domain.com
 * ```
 * @property clusterType The type of the WAF cluster. Valid values: `PhysicalCluster` and `VirtualCluster`. Default to `PhysicalCluster`.
 * @property connectionTime The connection timeout for WAF exclusive clusters. Unit: seconds.
 * @property domain Field `domain` has been deprecated from version 1.94.0. Use `domain_name` instead.
 * @property domainName The domain that you want to add to WAF. The `domain_name` is required when the value of the `domain`  is Empty.
 * @property http2Ports List of the HTTP 2.0 ports.
 * @property httpPorts List of the HTTP ports.
 * @property httpToUserIp Specifies whether to enable the HTTP back-to-origin feature. After this feature is enabled, the WAF instance can use HTTP to forward HTTPS requests to the origin server.
 * By default, port 80 is used to forward the requests to the origin server. Valid values: `On` and `Off`. Default to `Off`.
 * @property httpsPorts List of the HTTPS ports.
 * @property httpsRedirect Specifies whether to redirect HTTP requests as HTTPS requests. Valid values: "On" and `Off`. Default to `Off`.
 * @property instanceId The ID of the WAF instance.
 * @property isAccessProduct Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: `On` and `Off`. Default to `Off`.
 * @property loadBalancing The load balancing algorithm that is used to forward requests to the origin. Valid values: `IpHash` and `RoundRobin`. Default to `IpHash`.
 * @property logHeaders The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
 * * key: The key of label
 * * value: The value of label
 * @property readTime The read timeout of a WAF exclusive cluster. Unit: seconds.
 * @property resourceGroupId The ID of the resource group to which the queried domain belongs in Resource Management. By default, no value is specified, indicating that the domain belongs to the default resource group.
 * @property sourceIps List of the IP address or domain of the origin server to which the specified domain points.
 * @property writeTime The timeout period for a WAF exclusive cluster write connection. Unit: seconds.
 */
public data class DomainArgs(
    public val clusterType: Output<String>? = null,
    public val connectionTime: Output<Int>? = null,
    @Deprecated(
        message = """
  Field 'domain' has been deprecated from version 1.94.0. Use 'domain_name' instead.
  """,
    )
    public val domain: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val http2Ports: Output<List<String>>? = null,
    public val httpPorts: Output<List<String>>? = null,
    public val httpToUserIp: Output<String>? = null,
    public val httpsPorts: Output<List<String>>? = null,
    public val httpsRedirect: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val isAccessProduct: Output<String>? = null,
    public val loadBalancing: Output<String>? = null,
    public val logHeaders: Output<List<DomainLogHeaderArgs>>? = null,
    public val readTime: Output<Int>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val sourceIps: Output<List<String>>? = null,
    public val writeTime: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.waf.DomainArgs> {
    override fun toJava(): com.pulumi.alicloud.waf.DomainArgs =
        com.pulumi.alicloud.waf.DomainArgs.builder()
            .clusterType(clusterType?.applyValue({ args0 -> args0 }))
            .connectionTime(connectionTime?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .http2Ports(http2Ports?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .httpPorts(httpPorts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .httpToUserIp(httpToUserIp?.applyValue({ args0 -> args0 }))
            .httpsPorts(httpsPorts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .httpsRedirect(httpsRedirect?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .isAccessProduct(isAccessProduct?.applyValue({ args0 -> args0 }))
            .loadBalancing(loadBalancing?.applyValue({ args0 -> args0 }))
            .logHeaders(
                logHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .readTime(readTime?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .sourceIps(sourceIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .writeTime(writeTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var clusterType: Output<String>? = null

    private var connectionTime: Output<Int>? = null

    private var domain: Output<String>? = null

    private var domainName: Output<String>? = null

    private var http2Ports: Output<List<String>>? = null

    private var httpPorts: Output<List<String>>? = null

    private var httpToUserIp: Output<String>? = null

    private var httpsPorts: Output<List<String>>? = null

    private var httpsRedirect: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var isAccessProduct: Output<String>? = null

    private var loadBalancing: Output<String>? = null

    private var logHeaders: Output<List<DomainLogHeaderArgs>>? = null

    private var readTime: Output<Int>? = null

    private var resourceGroupId: Output<String>? = null

    private var sourceIps: Output<List<String>>? = null

    private var writeTime: Output<Int>? = null

    /**
     * @param value The type of the WAF cluster. Valid values: `PhysicalCluster` and `VirtualCluster`. Default to `PhysicalCluster`.
     */
    @JvmName("mnsuxdhnascowqjy")
    public suspend fun clusterType(`value`: Output<String>) {
        this.clusterType = value
    }

    /**
     * @param value The connection timeout for WAF exclusive clusters. Unit: seconds.
     */
    @JvmName("prrusjagjhrafowj")
    public suspend fun connectionTime(`value`: Output<Int>) {
        this.connectionTime = value
    }

    /**
     * @param value Field `domain` has been deprecated from version 1.94.0. Use `domain_name` instead.
     */
    @Deprecated(
        message = """
  Field 'domain' has been deprecated from version 1.94.0. Use 'domain_name' instead.
  """,
    )
    @JvmName("woyqxbagpnhninno")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The domain that you want to add to WAF. The `domain_name` is required when the value of the `domain`  is Empty.
     */
    @JvmName("dlutdtmbbpqfnhxt")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value List of the HTTP 2.0 ports.
     */
    @JvmName("cgyuqaqvbybunrtq")
    public suspend fun http2Ports(`value`: Output<List<String>>) {
        this.http2Ports = value
    }

    @JvmName("qkbnmcbfjvubsria")
    public suspend fun http2Ports(vararg values: Output<String>) {
        this.http2Ports = Output.all(values.asList())
    }

    /**
     * @param values List of the HTTP 2.0 ports.
     */
    @JvmName("pffhycjyyxagwmjt")
    public suspend fun http2Ports(values: List<Output<String>>) {
        this.http2Ports = Output.all(values)
    }

    /**
     * @param value List of the HTTP ports.
     */
    @JvmName("ooeuntmpfplffdwu")
    public suspend fun httpPorts(`value`: Output<List<String>>) {
        this.httpPorts = value
    }

    @JvmName("wyhbnogqwivhsbyr")
    public suspend fun httpPorts(vararg values: Output<String>) {
        this.httpPorts = Output.all(values.asList())
    }

    /**
     * @param values List of the HTTP ports.
     */
    @JvmName("vqyubhbsmqofpapi")
    public suspend fun httpPorts(values: List<Output<String>>) {
        this.httpPorts = Output.all(values)
    }

    /**
     * @param value Specifies whether to enable the HTTP back-to-origin feature. After this feature is enabled, the WAF instance can use HTTP to forward HTTPS requests to the origin server.
     * By default, port 80 is used to forward the requests to the origin server. Valid values: `On` and `Off`. Default to `Off`.
     */
    @JvmName("joruugmisgyvdlgo")
    public suspend fun httpToUserIp(`value`: Output<String>) {
        this.httpToUserIp = value
    }

    /**
     * @param value List of the HTTPS ports.
     */
    @JvmName("bvinfofvbsuksajd")
    public suspend fun httpsPorts(`value`: Output<List<String>>) {
        this.httpsPorts = value
    }

    @JvmName("brtrfqpknqxiyisv")
    public suspend fun httpsPorts(vararg values: Output<String>) {
        this.httpsPorts = Output.all(values.asList())
    }

    /**
     * @param values List of the HTTPS ports.
     */
    @JvmName("pnamothhxmsruyiy")
    public suspend fun httpsPorts(values: List<Output<String>>) {
        this.httpsPorts = Output.all(values)
    }

    /**
     * @param value Specifies whether to redirect HTTP requests as HTTPS requests. Valid values: "On" and `Off`. Default to `Off`.
     */
    @JvmName("rkrnudsjnufifeut")
    public suspend fun httpsRedirect(`value`: Output<String>) {
        this.httpsRedirect = value
    }

    /**
     * @param value The ID of the WAF instance.
     */
    @JvmName("jvwphhaduayeblam")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: `On` and `Off`. Default to `Off`.
     */
    @JvmName("dhykjwjtobgocpxo")
    public suspend fun isAccessProduct(`value`: Output<String>) {
        this.isAccessProduct = value
    }

    /**
     * @param value The load balancing algorithm that is used to forward requests to the origin. Valid values: `IpHash` and `RoundRobin`. Default to `IpHash`.
     */
    @JvmName("pbygbgxjnunhamdp")
    public suspend fun loadBalancing(`value`: Output<String>) {
        this.loadBalancing = value
    }

    /**
     * @param value The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
     * * key: The key of label
     * * value: The value of label
     */
    @JvmName("qessqaorsjuyesmw")
    public suspend fun logHeaders(`value`: Output<List<DomainLogHeaderArgs>>) {
        this.logHeaders = value
    }

    @JvmName("qaggogfkdwldvkyn")
    public suspend fun logHeaders(vararg values: Output<DomainLogHeaderArgs>) {
        this.logHeaders = Output.all(values.asList())
    }

    /**
     * @param values The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
     * * key: The key of label
     * * value: The value of label
     */
    @JvmName("ynchqnhlciwbytwb")
    public suspend fun logHeaders(values: List<Output<DomainLogHeaderArgs>>) {
        this.logHeaders = Output.all(values)
    }

    /**
     * @param value The read timeout of a WAF exclusive cluster. Unit: seconds.
     */
    @JvmName("rdosfmjorepmiywd")
    public suspend fun readTime(`value`: Output<Int>) {
        this.readTime = value
    }

    /**
     * @param value The ID of the resource group to which the queried domain belongs in Resource Management. By default, no value is specified, indicating that the domain belongs to the default resource group.
     */
    @JvmName("fgelyptscfsxdupq")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value List of the IP address or domain of the origin server to which the specified domain points.
     */
    @JvmName("spksppuwnbkcallp")
    public suspend fun sourceIps(`value`: Output<List<String>>) {
        this.sourceIps = value
    }

    @JvmName("clrtosksglgdptqw")
    public suspend fun sourceIps(vararg values: Output<String>) {
        this.sourceIps = Output.all(values.asList())
    }

    /**
     * @param values List of the IP address or domain of the origin server to which the specified domain points.
     */
    @JvmName("oreykgrtxcapuwhe")
    public suspend fun sourceIps(values: List<Output<String>>) {
        this.sourceIps = Output.all(values)
    }

    /**
     * @param value The timeout period for a WAF exclusive cluster write connection. Unit: seconds.
     */
    @JvmName("bamvgrpypnsxpitr")
    public suspend fun writeTime(`value`: Output<Int>) {
        this.writeTime = value
    }

    /**
     * @param value The type of the WAF cluster. Valid values: `PhysicalCluster` and `VirtualCluster`. Default to `PhysicalCluster`.
     */
    @JvmName("lwcbswkxukjbklfr")
    public suspend fun clusterType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterType = mapped
    }

    /**
     * @param value The connection timeout for WAF exclusive clusters. Unit: seconds.
     */
    @JvmName("wjyomecumucygohe")
    public suspend fun connectionTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionTime = mapped
    }

    /**
     * @param value Field `domain` has been deprecated from version 1.94.0. Use `domain_name` instead.
     */
    @Deprecated(
        message = """
  Field 'domain' has been deprecated from version 1.94.0. Use 'domain_name' instead.
  """,
    )
    @JvmName("wvaseocyrreotgpk")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The domain that you want to add to WAF. The `domain_name` is required when the value of the `domain`  is Empty.
     */
    @JvmName("qoqfqlnxswgcbhft")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value List of the HTTP 2.0 ports.
     */
    @JvmName("gbjqhspgwoaubgpa")
    public suspend fun http2Ports(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http2Ports = mapped
    }

    /**
     * @param values List of the HTTP 2.0 ports.
     */
    @JvmName("gkvcgfjhnkatbdlm")
    public suspend fun http2Ports(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.http2Ports = mapped
    }

    /**
     * @param value List of the HTTP ports.
     */
    @JvmName("yuioefbqelfbiaig")
    public suspend fun httpPorts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpPorts = mapped
    }

    /**
     * @param values List of the HTTP ports.
     */
    @JvmName("dmbswoyaovurqjhv")
    public suspend fun httpPorts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpPorts = mapped
    }

    /**
     * @param value Specifies whether to enable the HTTP back-to-origin feature. After this feature is enabled, the WAF instance can use HTTP to forward HTTPS requests to the origin server.
     * By default, port 80 is used to forward the requests to the origin server. Valid values: `On` and `Off`. Default to `Off`.
     */
    @JvmName("csgyeafssdkkoqox")
    public suspend fun httpToUserIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpToUserIp = mapped
    }

    /**
     * @param value List of the HTTPS ports.
     */
    @JvmName("bslphtfbhdlxwqnq")
    public suspend fun httpsPorts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsPorts = mapped
    }

    /**
     * @param values List of the HTTPS ports.
     */
    @JvmName("xjycktcagelpbxsx")
    public suspend fun httpsPorts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpsPorts = mapped
    }

    /**
     * @param value Specifies whether to redirect HTTP requests as HTTPS requests. Valid values: "On" and `Off`. Default to `Off`.
     */
    @JvmName("yecfhgunpcdldson")
    public suspend fun httpsRedirect(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsRedirect = mapped
    }

    /**
     * @param value The ID of the WAF instance.
     */
    @JvmName("kndorwhjrdrbhjci")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: `On` and `Off`. Default to `Off`.
     */
    @JvmName("mpiatrqgbevwlbny")
    public suspend fun isAccessProduct(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAccessProduct = mapped
    }

    /**
     * @param value The load balancing algorithm that is used to forward requests to the origin. Valid values: `IpHash` and `RoundRobin`. Default to `IpHash`.
     */
    @JvmName("qoclylknhjuloqox")
    public suspend fun loadBalancing(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancing = mapped
    }

    /**
     * @param value The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
     * * key: The key of label
     * * value: The value of label
     */
    @JvmName("ftgieqhwycfauotv")
    public suspend fun logHeaders(`value`: List<DomainLogHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logHeaders = mapped
    }

    /**
     * @param argument The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
     * * key: The key of label
     * * value: The value of label
     */
    @JvmName("taedmliusjlwmefr")
    public suspend fun logHeaders(argument: List<suspend DomainLogHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainLogHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logHeaders = mapped
    }

    /**
     * @param argument The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
     * * key: The key of label
     * * value: The value of label
     */
    @JvmName("gxhqfpvxudwyyjne")
    public suspend fun logHeaders(vararg argument: suspend DomainLogHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainLogHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logHeaders = mapped
    }

    /**
     * @param argument The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
     * * key: The key of label
     * * value: The value of label
     */
    @JvmName("jxfjdtxkknpgaeab")
    public suspend fun logHeaders(argument: suspend DomainLogHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DomainLogHeaderArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.logHeaders = mapped
    }

    /**
     * @param values The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
     * * key: The key of label
     * * value: The value of label
     */
    @JvmName("erlticnwdrqftnht")
    public suspend fun logHeaders(vararg values: DomainLogHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logHeaders = mapped
    }

    /**
     * @param value The read timeout of a WAF exclusive cluster. Unit: seconds.
     */
    @JvmName("wnqnpandmykgvdwe")
    public suspend fun readTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readTime = mapped
    }

    /**
     * @param value The ID of the resource group to which the queried domain belongs in Resource Management. By default, no value is specified, indicating that the domain belongs to the default resource group.
     */
    @JvmName("cppcnjfwcwspdwlo")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value List of the IP address or domain of the origin server to which the specified domain points.
     */
    @JvmName("dosykabwnhprplno")
    public suspend fun sourceIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIps = mapped
    }

    /**
     * @param values List of the IP address or domain of the origin server to which the specified domain points.
     */
    @JvmName("puwuletosbeyjkuu")
    public suspend fun sourceIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIps = mapped
    }

    /**
     * @param value The timeout period for a WAF exclusive cluster write connection. Unit: seconds.
     */
    @JvmName("pyxknbagbttponxm")
    public suspend fun writeTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeTime = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        clusterType = clusterType,
        connectionTime = connectionTime,
        domain = domain,
        domainName = domainName,
        http2Ports = http2Ports,
        httpPorts = httpPorts,
        httpToUserIp = httpToUserIp,
        httpsPorts = httpsPorts,
        httpsRedirect = httpsRedirect,
        instanceId = instanceId,
        isAccessProduct = isAccessProduct,
        loadBalancing = loadBalancing,
        logHeaders = logHeaders,
        readTime = readTime,
        resourceGroupId = resourceGroupId,
        sourceIps = sourceIps,
        writeTime = writeTime,
    )
}
