@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.waf.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.waf.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * > **DEPRECATED:**  This resource has been deprecated and using alicloud.wafv3.Instance instead.
 * Provides a WAF Instance resource to create instance in the Web Application Firewall.
 * For information about WAF and how to use it, see [What is Alibaba Cloud WAF](https://www.alibabacloud.com/help/doc-detail/28517.htm).
 * > **NOTE:** Available in 1.83.0+ .
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * export = async () => {
 *     const default = await alicloud.waf.getInstances({});
 *     const defaultInstance: alicloud.waf.Instance[] = [];
 *     for (const range = {value: 0}; range.value < (_default.instances.length > 0 ? 0 : 1); range.value++) {
 *         defaultInstance.push(new alicloud.waf.Instance(`default-${range.value}`, {
 *             bigScreen: "0",
 *             exclusiveIpPackage: "1",
 *             extBandwidth: "50",
 *             extDomainPackage: "1",
 *             packageCode: "version_3",
 *             prefessionalService: "false",
 *             subscriptionType: "Subscription",
 *             period: 1,
 *             wafLog: "false",
 *             logStorage: "3",
 *             logTime: "180",
 *             resourceGroupId: "rs-abc12345",
 *         }));
 *     }
 * }
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.waf.get_instances()
 * default_instance = []
 * for range in [{"value": i} for i in range(0, 0 if len(default&#46;instances) > 0 else 1)]:
 *     default_instance.append(alicloud.waf.Instance(f"default-{range['value']}",
 *         big_screen="0",
 *         exclusive_ip_package="1",
 *         ext_bandwidth="50",
 *         ext_domain_package="1",
 *         package_code="version_3",
 *         prefessional_service="false",
 *         subscription_type="Subscription",
 *         period=1,
 *         waf_log="false",
 *         log_storage="3",
 *         log_time="180",
 *         resource_group_id="rs-abc12345"))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Threading.Tasks;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(async() =>
 * {
 *     var @default = await AliCloud.Waf.GetInstances.InvokeAsync();
 *     var defaultInstance = new List<AliCloud.Waf.Instance>();
 *     for (var rangeIndex = 0; rangeIndex < @default.Instances.Length > 0 ? 0 : 1; rangeIndex++)
 *     {
 *         var range = new { Value = rangeIndex };
 *         defaultInstance.Add(new AliCloud.Waf.Instance($"default-{range.Value}", new()
 *         {
 *             BigScreen = "0",
 *             ExclusiveIpPackage = "1",
 *             ExtBandwidth = "50",
 *             ExtDomainPackage = "1",
 *             PackageCode = "version_3",
 *             PrefessionalService = "false",
 *             SubscriptionType = "Subscription",
 *             Period = 1,
 *             WafLog = "false",
 *             LogStorage = "3",
 *             LogTime = "180",
 *             ResourceGroupId = "rs-abc12345",
 *         }));
 *     }
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := waf.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		var tmp0 float64
 * 		if pulumi.Float64(len(_default.Instances)) > 0 {
 * 			tmp0 = 0
 * 		} else {
 * 			tmp0 = 1
 * 		}
 * 		var defaultInstance []*waf.Instance
 * 		for index := 0; index < tmp0; index++ {
 * 			key0 := index
 * 			_ := index
 * 			__res, err := waf.NewInstance(ctx, fmt.Sprintf("default-%v", key0), &waf.InstanceArgs{
 * 				BigScreen:           pulumi.String("0"),
 * 				ExclusiveIpPackage:  pulumi.String("1"),
 * 				ExtBandwidth:        pulumi.String("50"),
 * 				ExtDomainPackage:    pulumi.String("1"),
 * 				PackageCode:         pulumi.String("version_3"),
 * 				PrefessionalService: pulumi.String("false"),
 * 				SubscriptionType:    pulumi.String("Subscription"),
 * 				Period:              pulumi.Int(1),
 * 				WafLog:              pulumi.String("false"),
 * 				LogStorage:          pulumi.String("3"),
 * 				LogTime:             pulumi.String("180"),
 * 				ResourceGroupId:     pulumi.String("rs-abc12345"),
 * 			})
 * 			if err != nil {
 * 				return err
 * 			}
 * 			defaultInstance = append(defaultInstance, __res)
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.waf.WafFunctions;
 * import com.pulumi.alicloud.waf.inputs.GetInstancesArgs;
 * import com.pulumi.alicloud.waf.Instance;
 * import com.pulumi.alicloud.waf.InstanceArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = WafFunctions.getInstances();
 *         for (var i = 0; i < default_.instances().length() > 0 ? 0 : 1; i++) {
 *             new Instance("defaultInstance-" + i, InstanceArgs.builder()
 *                 .bigScreen("0")
 *                 .exclusiveIpPackage("1")
 *                 .extBandwidth("50")
 *                 .extDomainPackage("1")
 *                 .packageCode("version_3")
 *                 .prefessionalService("false")
 *                 .subscriptionType("Subscription")
 *                 .period(1)
 *                 .wafLog("false")
 *                 .logStorage("3")
 *                 .logTime("180")
 *                 .resourceGroupId("rs-abc12345")
 *                 .build());
 * }
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultInstance:
 *     type: alicloud:waf:Instance
 *     name: default
 *     properties:
 *       bigScreen: '0'
 *       exclusiveIpPackage: '1'
 *       extBandwidth: '50'
 *       extDomainPackage: '1'
 *       packageCode: version_3
 *       prefessionalService: 'false'
 *       subscriptionType: Subscription
 *       period: 1
 *       wafLog: 'false'
 *       logStorage: '3'
 *       logTime: '180'
 *       resourceGroupId: rs-abc12345
 *     options: {}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:waf:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * WAF instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:waf/instance:Instance default waf-cn-132435
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.waf.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * Specify whether big screen is supported. Valid values: ["0", "1"]. "0" for false and "1" for true.
     */
    public val bigScreen: Output<String>
        get() = javaResource.bigScreen().applyValue({ args0 -> args0 })

    /**
     * Specify the number of exclusive WAF IP addresses.
     */
    public val exclusiveIpPackage: Output<String>
        get() = javaResource.exclusiveIpPackage().applyValue({ args0 -> args0 })

    /**
     * The extra bandwidth. Unit: Mbit/s.
     */
    public val extBandwidth: Output<String>
        get() = javaResource.extBandwidth().applyValue({ args0 -> args0 })

    /**
     * The number of extra domains.
     */
    public val extDomainPackage: Output<String>
        get() = javaResource.extDomainPackage().applyValue({ args0 -> args0 })

    /**
     * Log storage size. Unit: T. Valid values: [3, 5, 10, 20, 50].
     */
    public val logStorage: Output<String>
        get() = javaResource.logStorage().applyValue({ args0 -> args0 })

    /**
     * Log storage period. Unit: day. Valid values: [180, 360].
     */
    public val logTime: Output<String>
        get() = javaResource.logTime().applyValue({ args0 -> args0 })

    /**
     * Type of configuration change. Valid value: Upgrade.
     */
    public val modifyType: Output<String>?
        get() = javaResource.modifyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Subscription plan:
     * * China site customers can purchase the following versions of China Mainland region, valid values: ["version_3", "version_4", "version_5"].
     * * China site customers can purchase the following versions of International region, valid values: ["version_pro_asia", "version_business_asia", "version_enterprise_asia"]
     * * International site customers can purchase the following versions of China Mainland region: ["version_pro_china", "version_business_china", "version_enterprise_china"]
     * * International site customers can purchase the following versions of International region: ["version_pro", "version_business", "version_enterprise"].
     */
    public val packageCode: Output<String>
        get() = javaResource.packageCode().applyValue({ args0 -> args0 })

    /**
     * Service time of Web Application Firewall.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specify whether professional service is supported. Valid values: ["true", "false"]
     */
    public val prefessionalService: Output<String>
        get() = javaResource.prefessionalService().applyValue({ args0 -> args0 })

    /**
     * The instance region ID.
     */
    public val region: Output<String>?
        get() = javaResource.region().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Renewal period of WAF service. Unit: month
     */
    public val renewPeriod: Output<Int>?
        get() = javaResource.renewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Renewal status of WAF service. Valid values:
     * * AutoRenewal: The service time of WAF is renewed automatically.
     * * ManualRenewal (default): The service time of WAF is renewed manually.Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: "On" and "Off". Default to "Off".
     */
    public val renewalStatus: Output<String>?
        get() = javaResource.renewalStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource group ID.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the instance.
     */
    public val status: Output<Int>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Subscription of WAF service. Valid values: ["Subscription", "PayAsYouGo"].
     */
    public val subscriptionType: Output<String>
        get() = javaResource.subscriptionType().applyValue({ args0 -> args0 })

    /**
     * Specify whether Log service is supported. Valid values: ["true", "false"]
     */
    public val wafLog: Output<String>
        get() = javaResource.wafLog().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.waf.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.waf.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
