@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.waf.kotlin

import com.pulumi.alicloud.waf.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * > **DEPRECATED:**  This resource has been deprecated and using alicloud.wafv3.Instance instead.
 * Provides a WAF Instance resource to create instance in the Web Application Firewall.
 * For information about WAF and how to use it, see [What is Alibaba Cloud WAF](https://www.alibabacloud.com/help/doc-detail/28517.htm).
 * > **NOTE:** Available in 1.83.0+ .
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * export = async () => {
 *     const default = await alicloud.waf.getInstances({});
 *     const defaultInstance: alicloud.waf.Instance[] = [];
 *     for (const range = {value: 0}; range.value < (_default.instances.length > 0 ? 0 : 1); range.value++) {
 *         defaultInstance.push(new alicloud.waf.Instance(`default-${range.value}`, {
 *             bigScreen: "0",
 *             exclusiveIpPackage: "1",
 *             extBandwidth: "50",
 *             extDomainPackage: "1",
 *             packageCode: "version_3",
 *             prefessionalService: "false",
 *             subscriptionType: "Subscription",
 *             period: 1,
 *             wafLog: "false",
 *             logStorage: "3",
 *             logTime: "180",
 *             resourceGroupId: "rs-abc12345",
 *         }));
 *     }
 * }
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.waf.get_instances()
 * default_instance = []
 * for range in [{"value": i} for i in range(0, 0 if len(default&#46;instances) > 0 else 1)]:
 *     default_instance.append(alicloud.waf.Instance(f"default-{range['value']}",
 *         big_screen="0",
 *         exclusive_ip_package="1",
 *         ext_bandwidth="50",
 *         ext_domain_package="1",
 *         package_code="version_3",
 *         prefessional_service="false",
 *         subscription_type="Subscription",
 *         period=1,
 *         waf_log="false",
 *         log_storage="3",
 *         log_time="180",
 *         resource_group_id="rs-abc12345"))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Threading.Tasks;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(async() =>
 * {
 *     var @default = await AliCloud.Waf.GetInstances.InvokeAsync();
 *     var defaultInstance = new List<AliCloud.Waf.Instance>();
 *     for (var rangeIndex = 0; rangeIndex < @default.Instances.Length > 0 ? 0 : 1; rangeIndex++)
 *     {
 *         var range = new { Value = rangeIndex };
 *         defaultInstance.Add(new AliCloud.Waf.Instance($"default-{range.Value}", new()
 *         {
 *             BigScreen = "0",
 *             ExclusiveIpPackage = "1",
 *             ExtBandwidth = "50",
 *             ExtDomainPackage = "1",
 *             PackageCode = "version_3",
 *             PrefessionalService = "false",
 *             SubscriptionType = "Subscription",
 *             Period = 1,
 *             WafLog = "false",
 *             LogStorage = "3",
 *             LogTime = "180",
 *             ResourceGroupId = "rs-abc12345",
 *         }));
 *     }
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := waf.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		var tmp0 float64
 * 		if pulumi.Float64(len(_default.Instances)) > 0 {
 * 			tmp0 = 0
 * 		} else {
 * 			tmp0 = 1
 * 		}
 * 		var defaultInstance []*waf.Instance
 * 		for index := 0; index < tmp0; index++ {
 * 			key0 := index
 * 			_ := index
 * 			__res, err := waf.NewInstance(ctx, fmt.Sprintf("default-%v", key0), &waf.InstanceArgs{
 * 				BigScreen:           pulumi.String("0"),
 * 				ExclusiveIpPackage:  pulumi.String("1"),
 * 				ExtBandwidth:        pulumi.String("50"),
 * 				ExtDomainPackage:    pulumi.String("1"),
 * 				PackageCode:         pulumi.String("version_3"),
 * 				PrefessionalService: pulumi.String("false"),
 * 				SubscriptionType:    pulumi.String("Subscription"),
 * 				Period:              pulumi.Int(1),
 * 				WafLog:              pulumi.String("false"),
 * 				LogStorage:          pulumi.String("3"),
 * 				LogTime:             pulumi.String("180"),
 * 				ResourceGroupId:     pulumi.String("rs-abc12345"),
 * 			})
 * 			if err != nil {
 * 				return err
 * 			}
 * 			defaultInstance = append(defaultInstance, __res)
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.waf.WafFunctions;
 * import com.pulumi.alicloud.waf.inputs.GetInstancesArgs;
 * import com.pulumi.alicloud.waf.Instance;
 * import com.pulumi.alicloud.waf.InstanceArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = WafFunctions.getInstances();
 *         for (var i = 0; i < default_.instances().length() > 0 ? 0 : 1; i++) {
 *             new Instance("defaultInstance-" + i, InstanceArgs.builder()
 *                 .bigScreen("0")
 *                 .exclusiveIpPackage("1")
 *                 .extBandwidth("50")
 *                 .extDomainPackage("1")
 *                 .packageCode("version_3")
 *                 .prefessionalService("false")
 *                 .subscriptionType("Subscription")
 *                 .period(1)
 *                 .wafLog("false")
 *                 .logStorage("3")
 *                 .logTime("180")
 *                 .resourceGroupId("rs-abc12345")
 *                 .build());
 * }
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultInstance:
 *     type: alicloud:waf:Instance
 *     name: default
 *     properties:
 *       bigScreen: '0'
 *       exclusiveIpPackage: '1'
 *       extBandwidth: '50'
 *       extDomainPackage: '1'
 *       packageCode: version_3
 *       prefessionalService: 'false'
 *       subscriptionType: Subscription
 *       period: 1
 *       wafLog: 'false'
 *       logStorage: '3'
 *       logTime: '180'
 *       resourceGroupId: rs-abc12345
 *     options: {}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:waf:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * WAF instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:waf/instance:Instance default waf-cn-132435
 * ```
 * @property bigScreen Specify whether big screen is supported. Valid values: ["0", "1"]. "0" for false and "1" for true.
 * @property exclusiveIpPackage Specify the number of exclusive WAF IP addresses.
 * @property extBandwidth The extra bandwidth. Unit: Mbit/s.
 * @property extDomainPackage The number of extra domains.
 * @property logStorage Log storage size. Unit: T. Valid values: [3, 5, 10, 20, 50].
 * @property logTime Log storage period. Unit: day. Valid values: [180, 360].
 * @property modifyType Type of configuration change. Valid value: Upgrade.
 * @property packageCode Subscription plan:
 * * China site customers can purchase the following versions of China Mainland region, valid values: ["version_3", "version_4", "version_5"].
 * * China site customers can purchase the following versions of International region, valid values: ["version_pro_asia", "version_business_asia", "version_enterprise_asia"]
 * * International site customers can purchase the following versions of China Mainland region: ["version_pro_china", "version_business_china", "version_enterprise_china"]
 * * International site customers can purchase the following versions of International region: ["version_pro", "version_business", "version_enterprise"].
 * @property period Service time of Web Application Firewall.
 * @property prefessionalService Specify whether professional service is supported. Valid values: ["true", "false"]
 * @property region The instance region ID.
 * @property renewPeriod Renewal period of WAF service. Unit: month
 * @property renewalStatus Renewal status of WAF service. Valid values:
 * * AutoRenewal: The service time of WAF is renewed automatically.
 * * ManualRenewal (default): The service time of WAF is renewed manually.Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: "On" and "Off". Default to "Off".
 * @property resourceGroupId The resource group ID.
 * @property subscriptionType Subscription of WAF service. Valid values: ["Subscription", "PayAsYouGo"].
 * @property wafLog Specify whether Log service is supported. Valid values: ["true", "false"]
 */
public data class InstanceArgs(
    public val bigScreen: Output<String>? = null,
    public val exclusiveIpPackage: Output<String>? = null,
    public val extBandwidth: Output<String>? = null,
    public val extDomainPackage: Output<String>? = null,
    public val logStorage: Output<String>? = null,
    public val logTime: Output<String>? = null,
    public val modifyType: Output<String>? = null,
    public val packageCode: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val prefessionalService: Output<String>? = null,
    public val region: Output<String>? = null,
    public val renewPeriod: Output<Int>? = null,
    public val renewalStatus: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val subscriptionType: Output<String>? = null,
    public val wafLog: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.waf.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.waf.InstanceArgs =
        com.pulumi.alicloud.waf.InstanceArgs.builder()
            .bigScreen(bigScreen?.applyValue({ args0 -> args0 }))
            .exclusiveIpPackage(exclusiveIpPackage?.applyValue({ args0 -> args0 }))
            .extBandwidth(extBandwidth?.applyValue({ args0 -> args0 }))
            .extDomainPackage(extDomainPackage?.applyValue({ args0 -> args0 }))
            .logStorage(logStorage?.applyValue({ args0 -> args0 }))
            .logTime(logTime?.applyValue({ args0 -> args0 }))
            .modifyType(modifyType?.applyValue({ args0 -> args0 }))
            .packageCode(packageCode?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .prefessionalService(prefessionalService?.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .renewPeriod(renewPeriod?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .subscriptionType(subscriptionType?.applyValue({ args0 -> args0 }))
            .wafLog(wafLog?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var bigScreen: Output<String>? = null

    private var exclusiveIpPackage: Output<String>? = null

    private var extBandwidth: Output<String>? = null

    private var extDomainPackage: Output<String>? = null

    private var logStorage: Output<String>? = null

    private var logTime: Output<String>? = null

    private var modifyType: Output<String>? = null

    private var packageCode: Output<String>? = null

    private var period: Output<Int>? = null

    private var prefessionalService: Output<String>? = null

    private var region: Output<String>? = null

    private var renewPeriod: Output<Int>? = null

    private var renewalStatus: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var subscriptionType: Output<String>? = null

    private var wafLog: Output<String>? = null

    /**
     * @param value Specify whether big screen is supported. Valid values: ["0", "1"]. "0" for false and "1" for true.
     */
    @JvmName("dnkvettxsspywblr")
    public suspend fun bigScreen(`value`: Output<String>) {
        this.bigScreen = value
    }

    /**
     * @param value Specify the number of exclusive WAF IP addresses.
     */
    @JvmName("hntolbrgxokeiptp")
    public suspend fun exclusiveIpPackage(`value`: Output<String>) {
        this.exclusiveIpPackage = value
    }

    /**
     * @param value The extra bandwidth. Unit: Mbit/s.
     */
    @JvmName("ltenomfwvjfrifpj")
    public suspend fun extBandwidth(`value`: Output<String>) {
        this.extBandwidth = value
    }

    /**
     * @param value The number of extra domains.
     */
    @JvmName("vspbkepsfxjrhosh")
    public suspend fun extDomainPackage(`value`: Output<String>) {
        this.extDomainPackage = value
    }

    /**
     * @param value Log storage size. Unit: T. Valid values: [3, 5, 10, 20, 50].
     */
    @JvmName("idujvixnfatuelko")
    public suspend fun logStorage(`value`: Output<String>) {
        this.logStorage = value
    }

    /**
     * @param value Log storage period. Unit: day. Valid values: [180, 360].
     */
    @JvmName("fmmkfxjjxyvqkklx")
    public suspend fun logTime(`value`: Output<String>) {
        this.logTime = value
    }

    /**
     * @param value Type of configuration change. Valid value: Upgrade.
     */
    @JvmName("cownffwjenjjuwwq")
    public suspend fun modifyType(`value`: Output<String>) {
        this.modifyType = value
    }

    /**
     * @param value Subscription plan:
     * * China site customers can purchase the following versions of China Mainland region, valid values: ["version_3", "version_4", "version_5"].
     * * China site customers can purchase the following versions of International region, valid values: ["version_pro_asia", "version_business_asia", "version_enterprise_asia"]
     * * International site customers can purchase the following versions of China Mainland region: ["version_pro_china", "version_business_china", "version_enterprise_china"]
     * * International site customers can purchase the following versions of International region: ["version_pro", "version_business", "version_enterprise"].
     */
    @JvmName("ghvsptqdggboiupl")
    public suspend fun packageCode(`value`: Output<String>) {
        this.packageCode = value
    }

    /**
     * @param value Service time of Web Application Firewall.
     */
    @JvmName("cumejtblgyhgdngn")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value Specify whether professional service is supported. Valid values: ["true", "false"]
     */
    @JvmName("ixymsqphycejneyk")
    public suspend fun prefessionalService(`value`: Output<String>) {
        this.prefessionalService = value
    }

    /**
     * @param value The instance region ID.
     */
    @JvmName("cfhpwlmrlmtfcopf")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value Renewal period of WAF service. Unit: month
     */
    @JvmName("nmuihkfkbyxmijia")
    public suspend fun renewPeriod(`value`: Output<Int>) {
        this.renewPeriod = value
    }

    /**
     * @param value Renewal status of WAF service. Valid values:
     * * AutoRenewal: The service time of WAF is renewed automatically.
     * * ManualRenewal (default): The service time of WAF is renewed manually.Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: "On" and "Off". Default to "Off".
     */
    @JvmName("whspyiaxqbvtibth")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value The resource group ID.
     */
    @JvmName("xtuuagmpxjpwrbro")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Subscription of WAF service. Valid values: ["Subscription", "PayAsYouGo"].
     */
    @JvmName("tslrghcgbtovqiok")
    public suspend fun subscriptionType(`value`: Output<String>) {
        this.subscriptionType = value
    }

    /**
     * @param value Specify whether Log service is supported. Valid values: ["true", "false"]
     */
    @JvmName("qwcurlfxqdexcjyv")
    public suspend fun wafLog(`value`: Output<String>) {
        this.wafLog = value
    }

    /**
     * @param value Specify whether big screen is supported. Valid values: ["0", "1"]. "0" for false and "1" for true.
     */
    @JvmName("rbfnuiqhkpfwsbyj")
    public suspend fun bigScreen(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bigScreen = mapped
    }

    /**
     * @param value Specify the number of exclusive WAF IP addresses.
     */
    @JvmName("txfpktgjlnwhgokc")
    public suspend fun exclusiveIpPackage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusiveIpPackage = mapped
    }

    /**
     * @param value The extra bandwidth. Unit: Mbit/s.
     */
    @JvmName("tgmhtsqevitalvmi")
    public suspend fun extBandwidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extBandwidth = mapped
    }

    /**
     * @param value The number of extra domains.
     */
    @JvmName("njilnagtmycerydy")
    public suspend fun extDomainPackage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extDomainPackage = mapped
    }

    /**
     * @param value Log storage size. Unit: T. Valid values: [3, 5, 10, 20, 50].
     */
    @JvmName("vmbswmvcenbrnprs")
    public suspend fun logStorage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStorage = mapped
    }

    /**
     * @param value Log storage period. Unit: day. Valid values: [180, 360].
     */
    @JvmName("iaqhwefcqkuascca")
    public suspend fun logTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logTime = mapped
    }

    /**
     * @param value Type of configuration change. Valid value: Upgrade.
     */
    @JvmName("wmpxjlefhqcimmxk")
    public suspend fun modifyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifyType = mapped
    }

    /**
     * @param value Subscription plan:
     * * China site customers can purchase the following versions of China Mainland region, valid values: ["version_3", "version_4", "version_5"].
     * * China site customers can purchase the following versions of International region, valid values: ["version_pro_asia", "version_business_asia", "version_enterprise_asia"]
     * * International site customers can purchase the following versions of China Mainland region: ["version_pro_china", "version_business_china", "version_enterprise_china"]
     * * International site customers can purchase the following versions of International region: ["version_pro", "version_business", "version_enterprise"].
     */
    @JvmName("yeaylnnxdryfwitu")
    public suspend fun packageCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageCode = mapped
    }

    /**
     * @param value Service time of Web Application Firewall.
     */
    @JvmName("cbwyiccdtkrmbdfs")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Specify whether professional service is supported. Valid values: ["true", "false"]
     */
    @JvmName("skbmxdoaitnvufbt")
    public suspend fun prefessionalService(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefessionalService = mapped
    }

    /**
     * @param value The instance region ID.
     */
    @JvmName("kyucauisnqbbirko")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value Renewal period of WAF service. Unit: month
     */
    @JvmName("febbtvqsqrdyxmpg")
    public suspend fun renewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewPeriod = mapped
    }

    /**
     * @param value Renewal status of WAF service. Valid values:
     * * AutoRenewal: The service time of WAF is renewed automatically.
     * * ManualRenewal (default): The service time of WAF is renewed manually.Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: "On" and "Off". Default to "Off".
     */
    @JvmName("exewinpoqtibgvnk")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value The resource group ID.
     */
    @JvmName("rqwrhucuipastwvi")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Subscription of WAF service. Valid values: ["Subscription", "PayAsYouGo"].
     */
    @JvmName("daqtxnuspkxoxphe")
    public suspend fun subscriptionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionType = mapped
    }

    /**
     * @param value Specify whether Log service is supported. Valid values: ["true", "false"]
     */
    @JvmName("kcfjktoeypaopphs")
    public suspend fun wafLog(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wafLog = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        bigScreen = bigScreen,
        exclusiveIpPackage = exclusiveIpPackage,
        extBandwidth = extBandwidth,
        extDomainPackage = extDomainPackage,
        logStorage = logStorage,
        logTime = logTime,
        modifyType = modifyType,
        packageCode = packageCode,
        period = period,
        prefessionalService = prefessionalService,
        region = region,
        renewPeriod = renewPeriod,
        renewalStatus = renewalStatus,
        resourceGroupId = resourceGroupId,
        subscriptionType = subscriptionType,
        wafLog = wafLog,
    )
}
