@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.waf.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProtectionModule].
 */
@PulumiTagMarker
public class ProtectionModuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProtectionModuleArgs = ProtectionModuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProtectionModuleArgsBuilder.() -> Unit) {
        val builder = ProtectionModuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProtectionModule {
        val builtJavaResource = com.pulumi.alicloud.waf.ProtectionModule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProtectionModule(builtJavaResource)
    }
}

/**
 * Provides a Web Application Firewall(WAF) Protection Module resource.
 * For information about Web Application Firewall(WAF) Protection Module and how to use it, see [What is Protection Module](https://www.alibabacloud.com/help/en/doc-detail/160775.htm).
 * > **NOTE:** Available in v1.141.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.waf.getInstances({});
 * const defaultDomain = new alicloud.waf.Domain("default", {
 *     domainName: "you domain",
 *     instanceId: _default.then(_default => _default.ids?.[0]),
 *     isAccessProduct: "On",
 *     sourceIps: ["1&#46;1&#46;1&#46;1"],
 *     clusterType: "PhysicalCluster",
 *     http2Ports: ["443"],
 *     httpPorts: ["80"],
 *     httpsPorts: ["443"],
 *     httpToUserIp: "Off",
 *     httpsRedirect: "Off",
 *     loadBalancing: "IpHash",
 *     logHeaders: [{
 *         key: "foo",
 *         value: "http",
 *     }],
 * });
 * const defaultProtectionModule = new alicloud.waf.ProtectionModule("default", {
 *     instanceId: _default.then(_default => _default.ids?.[0]),
 *     domain: defaultDomain.domainName,
 *     defenseType: "ac_cc",
 *     mode: 0,
 *     status: 0,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.waf.get_instances()
 * default_domain = alicloud.waf.Domain("default",
 *     domain_name="you domain",
 *     instance_id=default.ids[0],
 *     is_access_product="On",
 *     source_ips=["1&#46;1&#46;1&#46;1"],
 *     cluster_type="PhysicalCluster",
 *     http2_ports=["443"],
 *     http_ports=["80"],
 *     https_ports=["443"],
 *     http_to_user_ip="Off",
 *     https_redirect="Off",
 *     load_balancing="IpHash",
 *     log_headers=[{
 *         "key": "foo",
 *         "value": "http",
 *     }])
 * default_protection_module = alicloud.waf.ProtectionModule("default",
 *     instance_id=default.ids[0],
 *     domain=default_domain.domain_name,
 *     defense_type="ac_cc",
 *     mode=0,
 *     status=0)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.Waf.GetInstances.Invoke();
 *     var defaultDomain = new AliCloud.Waf.Domain("default", new()
 *     {
 *         DomainName = "you domain",
 *         InstanceId = @default.Apply(@default => @default.Apply(getInstancesResult => getInstancesResult.Ids[0])),
 *         IsAccessProduct = "On",
 *         SourceIps = new[]
 *         {
 *             "1.1.1.1",
 *         },
 *         ClusterType = "PhysicalCluster",
 *         Http2Ports = new[]
 *         {
 *             "443",
 *         },
 *         HttpPorts = new[]
 *         {
 *             "80",
 *         },
 *         HttpsPorts = new[]
 *         {
 *             "443",
 *         },
 *         HttpToUserIp = "Off",
 *         HttpsRedirect = "Off",
 *         LoadBalancing = "IpHash",
 *         LogHeaders = new[]
 *         {
 *             new AliCloud.Waf.Inputs.DomainLogHeaderArgs
 *             {
 *                 Key = "foo",
 *                 Value = "http",
 *             },
 *         },
 *     });
 *     var defaultProtectionModule = new AliCloud.Waf.ProtectionModule("default", new()
 *     {
 *         InstanceId = @default.Apply(@default => @default.Apply(getInstancesResult => getInstancesResult.Ids[0])),
 *         Domain = defaultDomain.DomainName,
 *         DefenseType = "ac_cc",
 *         Mode = 0,
 *         Status = 0,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := waf.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultDomain, err := waf.NewDomain(ctx, "default", &waf.DomainArgs{
 * 			DomainName:      pulumi.String("you domain"),
 * 			InstanceId:      pulumi.String(_default.Ids[0]),
 * 			IsAccessProduct: pulumi.String("On"),
 * 			SourceIps: pulumi.StringArray{
 * 				pulumi.String("1.1.1.1"),
 * 			},
 * 			ClusterType: pulumi.String("PhysicalCluster"),
 * 			Http2Ports: pulumi.StringArray{
 * 				pulumi.String("443"),
 * 			},
 * 			HttpPorts: pulumi.StringArray{
 * 				pulumi.String("80"),
 * 			},
 * 			HttpsPorts: pulumi.StringArray{
 * 				pulumi.String("443"),
 * 			},
 * 			HttpToUserIp:  pulumi.String("Off"),
 * 			HttpsRedirect: pulumi.String("Off"),
 * 			LoadBalancing: pulumi.String("IpHash"),
 * 			LogHeaders: waf.DomainLogHeaderArray{
 * 				&waf.DomainLogHeaderArgs{
 * 					Key:   pulumi.String("foo"),
 * 					Value: pulumi.String("http"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = waf.NewProtectionModule(ctx, "default", &waf.ProtectionModuleArgs{
 * 			InstanceId:  pulumi.String(_default.Ids[0]),
 * 			Domain:      defaultDomain.DomainName,
 * 			DefenseType: pulumi.String("ac_cc"),
 * 			Mode:        pulumi.Int(0),
 * 			Status:      pulumi.Int(0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.waf.WafFunctions;
 * import com.pulumi.alicloud.waf.inputs.GetInstancesArgs;
 * import com.pulumi.alicloud.waf.Domain;
 * import com.pulumi.alicloud.waf.DomainArgs;
 * import com.pulumi.alicloud.waf.inputs.DomainLogHeaderArgs;
 * import com.pulumi.alicloud.waf.ProtectionModule;
 * import com.pulumi.alicloud.waf.ProtectionModuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = WafFunctions.getInstances();
 *         var defaultDomain = new Domain("defaultDomain", DomainArgs.builder()
 *             .domainName("you domain")
 *             .instanceId(default_.ids()[0])
 *             .isAccessProduct("On")
 *             .sourceIps("1.1.1.1")
 *             .clusterType("PhysicalCluster")
 *             .http2Ports(443)
 *             .httpPorts(80)
 *             .httpsPorts(443)
 *             .httpToUserIp("Off")
 *             .httpsRedirect("Off")
 *             .loadBalancing("IpHash")
 *             .logHeaders(DomainLogHeaderArgs.builder()
 *                 .key("foo")
 *                 .value("http")
 *                 .build())
 *             .build());
 *         var defaultProtectionModule = new ProtectionModule("defaultProtectionModule", ProtectionModuleArgs.builder()
 *             .instanceId(default_.ids()[0])
 *             .domain(defaultDomain.domainName())
 *             .defenseType("ac_cc")
 *             .mode(0)
 *             .status(0)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultDomain:
 *     type: alicloud:waf:Domain
 *     name: default
 *     properties:
 *       domainName: you domain
 *       instanceId: ${default.ids[0]}
 *       isAccessProduct: On
 *       sourceIps:
 *         - 1.1.1.1
 *       clusterType: PhysicalCluster
 *       http2Ports:
 *         - 443
 *       httpPorts:
 *         - 80
 *       httpsPorts:
 *         - 443
 *       httpToUserIp: Off
 *       httpsRedirect: Off
 *       loadBalancing: IpHash
 *       logHeaders:
 *         - key: foo
 *           value: http
 *   defaultProtectionModule:
 *     type: alicloud:waf:ProtectionModule
 *     name: default
 *     properties:
 *       instanceId: ${default.ids[0]}
 *       domain: ${defaultDomain.domainName}
 *       defenseType: ac_cc
 *       mode: 0
 *       status: 0
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:waf:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Web Application Firewall(WAF) Protection Module can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:waf/protectionModule:ProtectionModule example <instance_id>:<domain>:<defense_type>
 * ```
 */
public class ProtectionModule internal constructor(
    override val javaResource: com.pulumi.alicloud.waf.ProtectionModule,
) : KotlinCustomResource(javaResource, ProtectionModuleMapper) {
    /**
     * The Protection Module. Valid values: `ac_cc`, `antifraud`, `dld`, `normalized`, `waf`.
     */
    public val defenseType: Output<String>
        get() = javaResource.defenseType().applyValue({ args0 -> args0 })

    /**
     * The domain name that is added to WAF.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * The ID of the WAF instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The protection mode of the specified protection module. **NOTE:** The value of the Mode parameter varies based on the value of the `defense_type` parameter.
     * * The `defense_type` is `waf`. `0`: block mode. `1`: warn mode.
     * * The `defense_type` is `dld`. `0`: warn mode. `1`: block mode.
     * * The `defense_type` is `ac_cc`. `0`: prevention mode. `1`: protection-emergency mode.
     * * The `defense_type` is `antifraud`. `0`: warn mode. `1`: block mode. `2`: strict interception mode.
     * * The `defense_type` is `normalized`. `0`: warn mode. `1`: block mode.
     */
    public val mode: Output<Int>
        get() = javaResource.mode().applyValue({ args0 -> args0 })

    /**
     * The status of the resource. Valid values: `0`, `1`.
     */
    public val status: Output<Int>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ProtectionModuleMapper : ResourceMapper<ProtectionModule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.waf.ProtectionModule::class == javaResource::class

    override fun map(javaResource: Resource): ProtectionModule = ProtectionModule(
        javaResource as
            com.pulumi.alicloud.waf.ProtectionModule,
    )
}

/**
 * @see [ProtectionModule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProtectionModule].
 */
public suspend fun protectionModule(
    name: String,
    block: suspend ProtectionModuleResourceBuilder.() -> Unit,
): ProtectionModule {
    val builder = ProtectionModuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProtectionModule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun protectionModule(name: String): ProtectionModule {
    val builder = ProtectionModuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
