@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.waf.kotlin

import com.pulumi.alicloud.waf.WafFunctions.getCertificatesPlain
import com.pulumi.alicloud.waf.WafFunctions.getDomainsPlain
import com.pulumi.alicloud.waf.WafFunctions.getInstancesPlain
import com.pulumi.alicloud.waf.kotlin.inputs.GetCertificatesPlainArgs
import com.pulumi.alicloud.waf.kotlin.inputs.GetCertificatesPlainArgsBuilder
import com.pulumi.alicloud.waf.kotlin.inputs.GetDomainsPlainArgs
import com.pulumi.alicloud.waf.kotlin.inputs.GetDomainsPlainArgsBuilder
import com.pulumi.alicloud.waf.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.waf.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.waf.kotlin.outputs.GetCertificatesResult
import com.pulumi.alicloud.waf.kotlin.outputs.GetDomainsResult
import com.pulumi.alicloud.waf.kotlin.outputs.GetInstancesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.waf.kotlin.outputs.GetCertificatesResult.Companion.toKotlin as getCertificatesResultToKotlin
import com.pulumi.alicloud.waf.kotlin.outputs.GetDomainsResult.Companion.toKotlin as getDomainsResultToKotlin
import com.pulumi.alicloud.waf.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin

public object WafFunctions {
    /**
     * This data source provides the Waf Certificates of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.135.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.waf.getCertificates({
     *     ids: ["your_certificate_id"],
     *     instanceId: "your_instance_id",
     *     domain: "your_domain_name",
     * });
     * export const wafCertificate = _default.then(_default => _default.certificates?.[0]);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.waf.get_certificates(ids=["your_certificate_id"],
     *     instance_id="your_instance_id",
     *     domain="your_domain_name")
     * pulumi.export("wafCertificate", default.certificates[0])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Waf.GetCertificates.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "your_certificate_id",
     *         },
     *         InstanceId = "your_instance_id",
     *         Domain = "your_domain_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["wafCertificate"] = @default&#46;Apply(@default => @default&#46;Apply(getCertificatesResult => getCertificatesResult&#46;Certificates[0])),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/waf"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := waf.GetCertificates(ctx, &waf.GetCertificatesArgs{
     * 			Ids: []string{
     * 				"your_certificate_id",
     * 			},
     * 			InstanceId: "your_instance_id",
     * 			Domain:     pulumi.StringRef("your_domain_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("wafCertificate", _default.Certificates[0])
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.waf.WafFunctions;
     * import com.pulumi.alicloud.waf.inputs.GetCertificatesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = WafFunctions.getCertificates(GetCertificatesArgs.builder()
     *             .ids("your_certificate_id")
     *             .instanceId("your_instance_id")
     *             .domain("your_domain_name")
     *             .build());
     *         ctx.export("wafCertificate", default_.certificates()[0]);
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:waf:getCertificates
     *       Arguments:
     *         ids:
     *           - your_certificate_id
     *         instanceId: your_instance_id
     *         domain: your_domain_name
     * outputs:
     *   wafCertificate: ${default.certificates[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCertificates.
     * @return A collection of values returned by getCertificates.
     */
    public suspend fun getCertificates(argument: GetCertificatesPlainArgs): GetCertificatesResult =
        getCertificatesResultToKotlin(getCertificatesPlain(argument.toJava()).await())

    /**
     * @see [getCertificates].
     * @param domain WAF domain name.
     * @param ids A list of Certificate IDs.
     * @param instanceId WAF instance ID.
     * @param nameRegex A regex string to filter results by Certificate name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getCertificates.
     */
    public suspend fun getCertificates(
        domain: String? = null,
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetCertificatesResult {
        val argument = GetCertificatesPlainArgs(
            domain = domain,
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getCertificatesResultToKotlin(getCertificatesPlain(argument.toJava()).await())
    }

    /**
     * @see [getCertificates].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;waf&#46;kotlin&#46;inputs&#46;GetCertificatesPlainArgs].
     * @return A collection of values returned by getCertificates.
     */
    public suspend fun getCertificates(argument: suspend GetCertificatesPlainArgsBuilder.() -> Unit): GetCertificatesResult {
        val builder = GetCertificatesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCertificatesResultToKotlin(getCertificatesPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides a WAF datasource to retrieve domains.
     * For information about WAF and how to use it, see [What is Alibaba Cloud WAF](https://www.alibabacloud.com/help/doc-detail/28517.htm).
     * > **NOTE:** Available in 1.86.0+ .
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.waf.getDomains({
     *     instanceId: "waf-cf-xxxxx",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.waf.get_domains(instance_id="waf-cf-xxxxx")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Waf.GetDomains.Invoke(new()
     *     {
     *         InstanceId = "waf-cf-xxxxx",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/waf"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := waf.GetDomains(ctx, &waf.GetDomainsArgs{
     * 			InstanceId: "waf-cf-xxxxx",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.waf.WafFunctions;
     * import com.pulumi.alicloud.waf.inputs.GetDomainsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = WafFunctions.getDomains(GetDomainsArgs.builder()
     *             .instanceId("waf-cf-xxxxx")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:waf:getDomains
     *       Arguments:
     *         instanceId: waf-cf-xxxxx
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDomains.
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(argument: GetDomainsPlainArgs): GetDomainsResult =
        getDomainsResultToKotlin(getDomainsPlain(argument.toJava()).await())

    /**
     * @see [getDomains].
     * @param enableDetails Default to false and only output `id`, `domain_name`. Set it to true can output more details.
     * @param ids A list of WAF domain names. Each item is domain name.
     * @param instanceId The Id of waf instance to which waf domain belongs.
     * @param nameRegex A regex string to filter results by domain name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the resource group to which the queried domain belongs in Resource Management.
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
    ): GetDomainsResult {
        val argument = GetDomainsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
        )
        return getDomainsResultToKotlin(getDomainsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomains].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;waf&#46;kotlin&#46;inputs&#46;GetDomainsPlainArgs].
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(argument: suspend GetDomainsPlainArgsBuilder.() -> Unit): GetDomainsResult {
        val builder = GetDomainsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainsResultToKotlin(getDomainsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides a WAF datasource to retrieve instances.
     * For information about WAF and how to use it, see [What is Alibaba Cloud WAF](https://www.alibabacloud.com/help/doc-detail/28517.htm).
     * > **NOTE:** Available in 1.90.0+ .
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.waf.getInstances({
     *     ids: ["waf-cn-09k********"],
     *     status: 1,
     *     resourceGroupId: "rg-acfmwvv********",
     *     instanceSource: "waf-cloud",
     * });
     * export const theFirstWafInstanceId = _default.then(_default => _default.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.waf.get_instances(ids=["waf-cn-09k********"],
     *     status=1,
     *     resource_group_id="rg-acfmwvv********",
     *     instance_source="waf-cloud")
     * pulumi.export("theFirstWafInstanceId", default.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Waf.GetInstances.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "waf-cn-09k********",
     *         },
     *         Status = 1,
     *         ResourceGroupId = "rg-acfmwvv********",
     *         InstanceSource = "waf-cloud",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["theFirstWafInstanceId"] = @default&#46;Apply(@default => @default&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/waf"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := waf.GetInstances(ctx, &waf.GetInstancesArgs{
     * 			Ids: []string{
     * 				"waf-cn-09k********",
     * 			},
     * 			Status:          pulumi.IntRef(1),
     * 			ResourceGroupId: pulumi.StringRef("rg-acfmwvv********"),
     * 			InstanceSource:  pulumi.StringRef("waf-cloud"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("theFirstWafInstanceId", _default.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.waf.WafFunctions;
     * import com.pulumi.alicloud.waf.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = WafFunctions.getInstances(GetInstancesArgs.builder()
     *             .ids("waf-cn-09k********")
     *             .status("1")
     *             .resourceGroupId("rg-acfmwvv********")
     *             .instanceSource("waf-cloud")
     *             .build());
     *         ctx.export("theFirstWafInstanceId", default_.instances()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:waf:getInstances
     *       Arguments:
     *         ids:
     *           - waf-cn-09k********
     *         status: '1'
     *         resourceGroupId: rg-acfmwvv********
     *         instanceSource: waf-cloud
     * outputs:
     *   theFirstWafInstanceId: ${default.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param ids A list of WAF instance IDs.
     * @param instanceSource The source of the WAF instance.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of resource group to which WAF instance belongs.
     * @param status The status of WAF instance to filter results. Optional value: `0`: The instance has expired, `1` : The instance has not expired and is working properly.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        ids: List<String>? = null,
        instanceSource: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        status: Int? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            ids = ids,
            instanceSource = instanceSource,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            status = status,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;waf&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }
}
