@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.waf.kotlin.inputs

import com.pulumi.alicloud.waf.inputs.DomainLogHeaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key
 * @property value
 */
public data class DomainLogHeaderArgs(
    public val key: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.waf.inputs.DomainLogHeaderArgs> {
    override fun toJava(): com.pulumi.alicloud.waf.inputs.DomainLogHeaderArgs =
        com.pulumi.alicloud.waf.inputs.DomainLogHeaderArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainLogHeaderArgs].
 */
@PulumiTagMarker
public class DomainLogHeaderArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("rpxqppkjtflilpwp")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value
     */
    @JvmName("oebuuusnjjnvoxxs")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value
     */
    @JvmName("fpfwumphdqsnayad")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value
     */
    @JvmName("dmeohgkwhihoffrc")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): DomainLogHeaderArgs = DomainLogHeaderArgs(
        key = key,
        `value` = `value`,
    )
}
