@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.waf.kotlin.inputs

import com.pulumi.alicloud.waf.inputs.GetDomainsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDomains.
 * @property enableDetails Default to false and only output `id`, `domain_name`. Set it to true can output more details.
 * @property ids A list of WAF domain names. Each item is domain name.
 * @property instanceId The Id of waf instance to which waf domain belongs.
 * @property nameRegex A regex string to filter results by domain name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The ID of the resource group to which the queried domain belongs in Resource Management.
 */
public data class GetDomainsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.waf.inputs.GetDomainsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.waf.inputs.GetDomainsPlainArgs =
        com.pulumi.alicloud.waf.inputs.GetDomainsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainsPlainArgs].
 */
@PulumiTagMarker
public class GetDomainsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    /**
     * @param value Default to false and only output `id`, `domain_name`. Set it to true can output more details.
     */
    @JvmName("fbbsxnmddywfauwx")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of WAF domain names. Each item is domain name.
     */
    @JvmName("elndofnurxvcplbu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of WAF domain names. Each item is domain name.
     */
    @JvmName("kuqvubfyjhkkifgb")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The Id of waf instance to which waf domain belongs.
     */
    @JvmName("rciujemtsbbwvbph")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by domain name.
     */
    @JvmName("jfmynycbfhsauarv")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ysbafjvqvircvlmb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the resource group to which the queried domain belongs in Resource Management.
     */
    @JvmName("bsmsutgypurelnbn")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    internal fun build(): GetDomainsPlainArgs = GetDomainsPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
    )
}
