@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.waf.kotlin.inputs

import com.pulumi.alicloud.waf.inputs.GetInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstances.
 * @property ids A list of WAF instance IDs.
 * @property instanceSource The source of the WAF instance.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The ID of resource group to which WAF instance belongs.
 * @property status The status of WAF instance to filter results. Optional value: `0`: The instance has expired, `1` : The instance has not expired and is working properly.
 */
public data class GetInstancesPlainArgs(
    public val ids: List<String>? = null,
    public val instanceSource: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val status: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.waf.inputs.GetInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.waf.inputs.GetInstancesPlainArgs =
        com.pulumi.alicloud.waf.inputs.GetInstancesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceSource(instanceSource?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetInstancesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceSource: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var status: Int? = null

    /**
     * @param value A list of WAF instance IDs.
     */
    @JvmName("wavjwgsqobpxwhfu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of WAF instance IDs.
     */
    @JvmName("xvhlvqwnuvpqkxoh")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The source of the WAF instance.
     */
    @JvmName("bqcxblvdiayvroew")
    public suspend fun instanceSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceSource = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("lfcpxohuovfwmkbx")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of resource group to which WAF instance belongs.
     */
    @JvmName("iyemkdxhtmjcmwau")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The status of WAF instance to filter results. Optional value: `0`: The instance has expired, `1` : The instance has not expired and is working properly.
     */
    @JvmName("dkxhycocwooaayuc")
    public suspend fun status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetInstancesPlainArgs = GetInstancesPlainArgs(
        ids = ids,
        instanceSource = instanceSource,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        status = status,
    )
}
