@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.waf.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property certificateId Certificate recording ID.
 * @property certificateName Your certificate name.
 * @property commonName Certificate bound to the domain name.
 * @property domain The domain that you want to add to WAF.
 * @property id The ID of the Certificate.
 * @property instanceId WAF instance ID.
 * @property isUsing
 * @property sans
 */
public data class GetCertificatesCertificate(
    public val certificateId: String,
    public val certificateName: String,
    public val commonName: String,
    public val domain: String,
    public val id: String,
    public val instanceId: String,
    public val isUsing: Boolean,
    public val sans: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.waf.outputs.GetCertificatesCertificate): GetCertificatesCertificate = GetCertificatesCertificate(
            certificateId = javaType.certificateId(),
            certificateName = javaType.certificateName(),
            commonName = javaType.commonName(),
            domain = javaType.domain(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            isUsing = javaType.isUsing(),
            sans = javaType.sans().map({ args0 -> args0 }),
        )
    }
}
