@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.waf.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCertificates.
 * @property certificates
 * @property domain
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId
 * @property nameRegex
 * @property names
 * @property outputFile
 */
public data class GetCertificatesResult(
    public val certificates: List<GetCertificatesCertificate>,
    public val domain: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.waf.outputs.GetCertificatesResult): GetCertificatesResult = GetCertificatesResult(
            certificates = javaType.certificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.waf.kotlin.outputs.GetCertificatesCertificate.Companion.toKotlin(args0)
                })
            }),
            domain = javaType.domain().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
