@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.waf.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property clusterType The type of the WAF cluster.
 * @property cname The CNAME record assigned by the WAF instance to the specified domain.
 * @property connectionTime The connection timeout for WAF exclusive clusters. Valid values: `PhysicalCluster` and `VirtualCluster`. Default to `PhysicalCluster`.
 * @property domain Field `domain` has been deprecated from version 1.94.0. Use `domain_name` instead.
 * @property domainName Name of the domain.
 * @property http2Ports List of the HTTP 2.0 ports.
 * @property httpPorts List of the HTTP ports.
 * @property httpToUserIp Specifies whether to enable the HTTP back-to-origin feature. After this feature is enabled, the WAF instance can use HTTP to forward HTTPS requests to the origin server.
 * @property httpsPorts List of the HTTPS ports.
 * @property httpsRedirect Specifies whether to redirect HTTP requests as HTTPS requests. Valid values: `On` and `Off`. Default to `Off`.
 * @property id The ID of domain self ID, value as `domain_name`.
 * @property isAccessProduct Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: `On` and "Off". Default to `Off`.
 * @property loadBalancing The load balancing algorithm that is used to forward requests to the origin. Valid values: `IpHash` and `RoundRobin`. Default to `IpHash`.
 * @property logHeaders The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
 * @property readTime The read timeout of a WAF exclusive cluster. Unit: seconds.
 * @property resourceGroupId The ID of the resource group to which the queried domain belongs in Resource Management.
 * @property sourceIps List of the IP address or domain of the origin server to which the specified domain points.
 * @property version The system data identifier that is used to control optimistic locking.
 * @property writeTime The timeout period for a WAF exclusive cluster write connection. Unit: seconds.
 * ```
 */
public data class GetDomainsDomain(
    public val clusterType: String,
    public val cname: String,
    public val connectionTime: Int,
    public val domain: String,
    public val domainName: String,
    public val http2Ports: List<String>,
    public val httpPorts: List<String>,
    public val httpToUserIp: String,
    public val httpsPorts: List<String>,
    public val httpsRedirect: String,
    public val id: String,
    public val isAccessProduct: String,
    public val loadBalancing: String,
    public val logHeaders: List<GetDomainsDomainLogHeader>,
    public val readTime: Int,
    public val resourceGroupId: String,
    public val sourceIps: List<String>,
    public val version: Int,
    public val writeTime: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.waf.outputs.GetDomainsDomain): GetDomainsDomain = GetDomainsDomain(
            clusterType = javaType.clusterType(),
            cname = javaType.cname(),
            connectionTime = javaType.connectionTime(),
            domain = javaType.domain(),
            domainName = javaType.domainName(),
            http2Ports = javaType.http2Ports().map({ args0 -> args0 }),
            httpPorts = javaType.httpPorts().map({ args0 -> args0 }),
            httpToUserIp = javaType.httpToUserIp(),
            httpsPorts = javaType.httpsPorts().map({ args0 -> args0 }),
            httpsRedirect = javaType.httpsRedirect(),
            id = javaType.id(),
            isAccessProduct = javaType.isAccessProduct(),
            loadBalancing = javaType.loadBalancing(),
            logHeaders = javaType.logHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.waf.kotlin.outputs.GetDomainsDomainLogHeader.Companion.toKotlin(args0)
                })
            }),
            readTime = javaType.readTime(),
            resourceGroupId = javaType.resourceGroupId(),
            sourceIps = javaType.sourceIps().map({ args0 -> args0 }),
            version = javaType.version(),
            writeTime = javaType.writeTime(),
        )
    }
}
