@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.waf.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endDate The timestamp (in seconds) indicating when the WAF instance expires.
 * @property id The ID of the WAF instance.
 * @property inDebt Indicates whether the WAF instance has overdue payments.
 * @property instanceId The ID of WAF the instance.
 * @property remainDay The number of days before the trial period of the WAF instance expires.
 * @property status The status of WAF instance to filter results. Optional value: `0`: The instance has expired, `1` : The instance has not expired and is working properly.
 * @property subscriptionType
 * @property trial Indicates whether this is a trial instance.
 */
public data class GetInstancesInstance(
    public val endDate: Int,
    public val id: String,
    public val inDebt: Int,
    public val instanceId: String,
    public val remainDay: Int,
    public val status: Int,
    public val subscriptionType: String,
    public val trial: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.waf.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            endDate = javaType.endDate(),
            id = javaType.id(),
            inDebt = javaType.inDebt(),
            instanceId = javaType.instanceId(),
            remainDay = javaType.remainDay(),
            status = javaType.status(),
            subscriptionType = javaType.subscriptionType(),
            trial = javaType.trial(),
        )
    }
}
