@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.waf.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstances.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids (Optional) A list of WAF instance IDs.
 * @property instanceSource
 * @property instances A list of WAF instances. Each element contains the following attributes:
 * @property outputFile
 * @property resourceGroupId
 * @property status Indicates whether the WAF instance has expired.
 */
public data class GetInstancesResult(
    public val id: String,
    public val ids: List<String>,
    public val instanceSource: String? = null,
    public val instances: List<GetInstancesInstance>,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val status: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.waf.outputs.GetInstancesResult): GetInstancesResult = GetInstancesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceSource = javaType.instanceSource().map({ args0 -> args0 }).orElse(null),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.waf.kotlin.outputs.GetInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
