@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.wafv3.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DefenseTemplate].
 */
@PulumiTagMarker
public class DefenseTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DefenseTemplateArgs = DefenseTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DefenseTemplateArgsBuilder.() -> Unit) {
        val builder = DefenseTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DefenseTemplate {
        val builtJavaResource = com.pulumi.alicloud.wafv3.DefenseTemplate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DefenseTemplate(builtJavaResource)
    }
}

/**
 * Provides a WAFV3 Defense Template resource.
 * For information about WAFV3 Defense Template and how to use it, see [What is Defense Template](https://www.alibabacloud.com/help/en/web-application-firewall/latest/api-waf-openapi-2021-10-01-createdefensetemplate).
 * > **NOTE:** Available since v1.218.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.wafv3.getInstances({});
 * const defaultDefenseTemplate = new alicloud.wafv3.DefenseTemplate("default", {
 *     status: "1",
 *     instanceId: _default.then(_default => _default.ids?.[0]),
 *     defenseTemplateName: name,
 *     templateType: "user_custom",
 *     templateOrigin: "custom",
 *     defenseScene: "antiscan",
 *     resourceManagerResourceGroupId: "example",
 *     description: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.wafv3.get_instances()
 * default_defense_template = alicloud.wafv3.DefenseTemplate("default",
 *     status="1",
 *     instance_id=default.ids[0],
 *     defense_template_name=name,
 *     template_type="user_custom",
 *     template_origin="custom",
 *     defense_scene="antiscan",
 *     resource_manager_resource_group_id="example",
 *     description=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.Wafv3.GetInstances.Invoke();
 *     var defaultDefenseTemplate = new AliCloud.Wafv3.DefenseTemplate("default", new()
 *     {
 *         Status = "1",
 *         InstanceId = @default.Apply(@default => @default.Apply(getInstancesResult => getInstancesResult.Ids[0])),
 *         DefenseTemplateName = name,
 *         TemplateType = "user_custom",
 *         TemplateOrigin = "custom",
 *         DefenseScene = "antiscan",
 *         ResourceManagerResourceGroupId = "example",
 *         Description = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/wafv3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := wafv3.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = wafv3.NewDefenseTemplate(ctx, "default", &wafv3.DefenseTemplateArgs{
 * 			Status:                         pulumi.String("1"),
 * 			InstanceId:                     pulumi.String(_default.Ids[0]),
 * 			DefenseTemplateName:            pulumi.String(name),
 * 			TemplateType:                   pulumi.String("user_custom"),
 * 			TemplateOrigin:                 pulumi.String("custom"),
 * 			DefenseScene:                   pulumi.String("antiscan"),
 * 			ResourceManagerResourceGroupId: pulumi.String("example"),
 * 			Description:                    pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.wafv3.Wafv3Functions;
 * import com.pulumi.alicloud.wafv3.inputs.GetInstancesArgs;
 * import com.pulumi.alicloud.wafv3.DefenseTemplate;
 * import com.pulumi.alicloud.wafv3.DefenseTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = Wafv3Functions.getInstances();
 *         var defaultDefenseTemplate = new DefenseTemplate("defaultDefenseTemplate", DefenseTemplateArgs.builder()
 *             .status("1")
 *             .instanceId(default_.ids()[0])
 *             .defenseTemplateName(name)
 *             .templateType("user_custom")
 *             .templateOrigin("custom")
 *             .defenseScene("antiscan")
 *             .resourceManagerResourceGroupId("example")
 *             .description(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultDefenseTemplate:
 *     type: alicloud:wafv3:DefenseTemplate
 *     name: default
 *     properties:
 *       status: '1'
 *       instanceId: ${default.ids[0]}
 *       defenseTemplateName: ${name}
 *       templateType: user_custom
 *       templateOrigin: custom
 *       defenseScene: antiscan
 *       resourceManagerResourceGroupId: example
 *       description: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:wafv3:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * WAFV3 Defense Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:wafv3/defenseTemplate:DefenseTemplate example <instance_id>:<defense_template_id>
 * ```
 */
public class DefenseTemplate internal constructor(
    override val javaResource: com.pulumi.alicloud.wafv3.DefenseTemplate,
) : KotlinCustomResource(javaResource, DefenseTemplateMapper) {
    /**
     * The module to which the protection rule that you want to create belongs. Value:
     * - **waf_group**: the basic protection rule module.
     * - **antiscan**: the scan protection module.
     * - **ip_blacklist**: the IP address blacklist module.
     * - **custom_acl**: the custom rule module.
     * - **whitelist**: the whitelist module.
     * - **region_block**: the region blacklist module.
     * - **custom_response**: the custom response module.
     * - **cc**: the HTTP flood protection module.
     * - **tamperproof**: the website tamper-proofing module.
     * - **dlp**: the data leakage prevention module.
     */
    public val defenseScene: Output<String>
        get() = javaResource.defenseScene().applyValue({ args0 -> args0 })

    /**
     * Template ID.
     */
    public val defenseTemplateId: Output<Int>
        get() = javaResource.defenseTemplateId().applyValue({ args0 -> args0 })

    /**
     * The name of the protection rule template.
     */
    public val defenseTemplateName: Output<String>
        get() = javaResource.defenseTemplateName().applyValue({ args0 -> args0 })

    /**
     * The description of the protection rule template. .
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the Web Application Firewall (WAF) instance. .
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Alibaba Cloud resource group. .
     */
    public val resourceManagerResourceGroupId: Output<String>?
        get() = javaResource.resourceManagerResourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the protection rule template. Valid values:
     * - **0**: disabled.
     * - **1**: enabled.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The origin of the protection rule template that you want to create. Set the value to **custom**. The value specifies that the protection rule template is a custom template. .
     */
    public val templateOrigin: Output<String>
        get() = javaResource.templateOrigin().applyValue({ args0 -> args0 })

    /**
     * The type of the protection rule template. Valid values:
     * - **user_default:** default template.
     * - **user_custom:** custom template.
     */
    public val templateType: Output<String>
        get() = javaResource.templateType().applyValue({ args0 -> args0 })
}

public object DefenseTemplateMapper : ResourceMapper<DefenseTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.wafv3.DefenseTemplate::class == javaResource::class

    override fun map(javaResource: Resource): DefenseTemplate = DefenseTemplate(
        javaResource as
            com.pulumi.alicloud.wafv3.DefenseTemplate,
    )
}

/**
 * @see [DefenseTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DefenseTemplate].
 */
public suspend fun defenseTemplate(
    name: String,
    block: suspend DefenseTemplateResourceBuilder.() -> Unit,
): DefenseTemplate {
    val builder = DefenseTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DefenseTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun defenseTemplate(name: String): DefenseTemplate {
    val builder = DefenseTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
