@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.wafv3.kotlin

import com.pulumi.alicloud.wafv3.DefenseTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a WAFV3 Defense Template resource.
 * For information about WAFV3 Defense Template and how to use it, see [What is Defense Template](https://www.alibabacloud.com/help/en/web-application-firewall/latest/api-waf-openapi-2021-10-01-createdefensetemplate).
 * > **NOTE:** Available since v1.218.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.wafv3.getInstances({});
 * const defaultDefenseTemplate = new alicloud.wafv3.DefenseTemplate("default", {
 *     status: "1",
 *     instanceId: _default.then(_default => _default.ids?.[0]),
 *     defenseTemplateName: name,
 *     templateType: "user_custom",
 *     templateOrigin: "custom",
 *     defenseScene: "antiscan",
 *     resourceManagerResourceGroupId: "example",
 *     description: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.wafv3.get_instances()
 * default_defense_template = alicloud.wafv3.DefenseTemplate("default",
 *     status="1",
 *     instance_id=default.ids[0],
 *     defense_template_name=name,
 *     template_type="user_custom",
 *     template_origin="custom",
 *     defense_scene="antiscan",
 *     resource_manager_resource_group_id="example",
 *     description=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.Wafv3.GetInstances.Invoke();
 *     var defaultDefenseTemplate = new AliCloud.Wafv3.DefenseTemplate("default", new()
 *     {
 *         Status = "1",
 *         InstanceId = @default.Apply(@default => @default.Apply(getInstancesResult => getInstancesResult.Ids[0])),
 *         DefenseTemplateName = name,
 *         TemplateType = "user_custom",
 *         TemplateOrigin = "custom",
 *         DefenseScene = "antiscan",
 *         ResourceManagerResourceGroupId = "example",
 *         Description = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/wafv3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := wafv3.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = wafv3.NewDefenseTemplate(ctx, "default", &wafv3.DefenseTemplateArgs{
 * 			Status:                         pulumi.String("1"),
 * 			InstanceId:                     pulumi.String(_default.Ids[0]),
 * 			DefenseTemplateName:            pulumi.String(name),
 * 			TemplateType:                   pulumi.String("user_custom"),
 * 			TemplateOrigin:                 pulumi.String("custom"),
 * 			DefenseScene:                   pulumi.String("antiscan"),
 * 			ResourceManagerResourceGroupId: pulumi.String("example"),
 * 			Description:                    pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.wafv3.Wafv3Functions;
 * import com.pulumi.alicloud.wafv3.inputs.GetInstancesArgs;
 * import com.pulumi.alicloud.wafv3.DefenseTemplate;
 * import com.pulumi.alicloud.wafv3.DefenseTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = Wafv3Functions.getInstances();
 *         var defaultDefenseTemplate = new DefenseTemplate("defaultDefenseTemplate", DefenseTemplateArgs.builder()
 *             .status("1")
 *             .instanceId(default_.ids()[0])
 *             .defenseTemplateName(name)
 *             .templateType("user_custom")
 *             .templateOrigin("custom")
 *             .defenseScene("antiscan")
 *             .resourceManagerResourceGroupId("example")
 *             .description(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultDefenseTemplate:
 *     type: alicloud:wafv3:DefenseTemplate
 *     name: default
 *     properties:
 *       status: '1'
 *       instanceId: ${default.ids[0]}
 *       defenseTemplateName: ${name}
 *       templateType: user_custom
 *       templateOrigin: custom
 *       defenseScene: antiscan
 *       resourceManagerResourceGroupId: example
 *       description: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:wafv3:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * WAFV3 Defense Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:wafv3/defenseTemplate:DefenseTemplate example <instance_id>:<defense_template_id>
 * ```
 * @property defenseScene The module to which the protection rule that you want to create belongs. Value:
 * - **waf_group**: the basic protection rule module.
 * - **antiscan**: the scan protection module.
 * - **ip_blacklist**: the IP address blacklist module.
 * - **custom_acl**: the custom rule module.
 * - **whitelist**: the whitelist module.
 * - **region_block**: the region blacklist module.
 * - **custom_response**: the custom response module.
 * - **cc**: the HTTP flood protection module.
 * - **tamperproof**: the website tamper-proofing module.
 * - **dlp**: the data leakage prevention module.
 * @property defenseTemplateName The name of the protection rule template.
 * @property description The description of the protection rule template. .
 * @property instanceId The ID of the Web Application Firewall (WAF) instance. .
 * @property resourceManagerResourceGroupId The ID of the Alibaba Cloud resource group. .
 * @property status The status of the protection rule template. Valid values:
 * - **0**: disabled.
 * - **1**: enabled.
 * @property templateOrigin The origin of the protection rule template that you want to create. Set the value to **custom**. The value specifies that the protection rule template is a custom template. .
 * @property templateType The type of the protection rule template. Valid values:
 * - **user_default:** default template.
 * - **user_custom:** custom template.
 */
public data class DefenseTemplateArgs(
    public val defenseScene: Output<String>? = null,
    public val defenseTemplateName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val resourceManagerResourceGroupId: Output<String>? = null,
    public val status: Output<String>? = null,
    public val templateOrigin: Output<String>? = null,
    public val templateType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.wafv3.DefenseTemplateArgs> {
    override fun toJava(): com.pulumi.alicloud.wafv3.DefenseTemplateArgs =
        com.pulumi.alicloud.wafv3.DefenseTemplateArgs.builder()
            .defenseScene(defenseScene?.applyValue({ args0 -> args0 }))
            .defenseTemplateName(defenseTemplateName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .resourceManagerResourceGroupId(resourceManagerResourceGroupId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .templateOrigin(templateOrigin?.applyValue({ args0 -> args0 }))
            .templateType(templateType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenseTemplateArgs].
 */
@PulumiTagMarker
public class DefenseTemplateArgsBuilder internal constructor() {
    private var defenseScene: Output<String>? = null

    private var defenseTemplateName: Output<String>? = null

    private var description: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var resourceManagerResourceGroupId: Output<String>? = null

    private var status: Output<String>? = null

    private var templateOrigin: Output<String>? = null

    private var templateType: Output<String>? = null

    /**
     * @param value The module to which the protection rule that you want to create belongs. Value:
     * - **waf_group**: the basic protection rule module.
     * - **antiscan**: the scan protection module.
     * - **ip_blacklist**: the IP address blacklist module.
     * - **custom_acl**: the custom rule module.
     * - **whitelist**: the whitelist module.
     * - **region_block**: the region blacklist module.
     * - **custom_response**: the custom response module.
     * - **cc**: the HTTP flood protection module.
     * - **tamperproof**: the website tamper-proofing module.
     * - **dlp**: the data leakage prevention module.
     */
    @JvmName("sovlveeiewvckuoe")
    public suspend fun defenseScene(`value`: Output<String>) {
        this.defenseScene = value
    }

    /**
     * @param value The name of the protection rule template.
     */
    @JvmName("leydbdnvvvwlyaro")
    public suspend fun defenseTemplateName(`value`: Output<String>) {
        this.defenseTemplateName = value
    }

    /**
     * @param value The description of the protection rule template. .
     */
    @JvmName("qtwxglccvkbgadjf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the Web Application Firewall (WAF) instance. .
     */
    @JvmName("wrymrwbcuepmqcdh")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The ID of the Alibaba Cloud resource group. .
     */
    @JvmName("yysdwsrybqavmsgm")
    public suspend fun resourceManagerResourceGroupId(`value`: Output<String>) {
        this.resourceManagerResourceGroupId = value
    }

    /**
     * @param value The status of the protection rule template. Valid values:
     * - **0**: disabled.
     * - **1**: enabled.
     */
    @JvmName("dtcfmlivvfqkspst")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The origin of the protection rule template that you want to create. Set the value to **custom**. The value specifies that the protection rule template is a custom template. .
     */
    @JvmName("jfgthjegvfygljwu")
    public suspend fun templateOrigin(`value`: Output<String>) {
        this.templateOrigin = value
    }

    /**
     * @param value The type of the protection rule template. Valid values:
     * - **user_default:** default template.
     * - **user_custom:** custom template.
     */
    @JvmName("crsmllapptowmajy")
    public suspend fun templateType(`value`: Output<String>) {
        this.templateType = value
    }

    /**
     * @param value The module to which the protection rule that you want to create belongs. Value:
     * - **waf_group**: the basic protection rule module.
     * - **antiscan**: the scan protection module.
     * - **ip_blacklist**: the IP address blacklist module.
     * - **custom_acl**: the custom rule module.
     * - **whitelist**: the whitelist module.
     * - **region_block**: the region blacklist module.
     * - **custom_response**: the custom response module.
     * - **cc**: the HTTP flood protection module.
     * - **tamperproof**: the website tamper-proofing module.
     * - **dlp**: the data leakage prevention module.
     */
    @JvmName("yifpbawgwbbqjree")
    public suspend fun defenseScene(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defenseScene = mapped
    }

    /**
     * @param value The name of the protection rule template.
     */
    @JvmName("guhjolinlejjsuse")
    public suspend fun defenseTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defenseTemplateName = mapped
    }

    /**
     * @param value The description of the protection rule template. .
     */
    @JvmName("tiatgyhqtjasjdjo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the Web Application Firewall (WAF) instance. .
     */
    @JvmName("ltkvcefrestpceoq")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The ID of the Alibaba Cloud resource group. .
     */
    @JvmName("aspqlcshttlbfrok")
    public suspend fun resourceManagerResourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceManagerResourceGroupId = mapped
    }

    /**
     * @param value The status of the protection rule template. Valid values:
     * - **0**: disabled.
     * - **1**: enabled.
     */
    @JvmName("qagcqwstudxynkhf")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The origin of the protection rule template that you want to create. Set the value to **custom**. The value specifies that the protection rule template is a custom template. .
     */
    @JvmName("idvuehwrfxwwsutb")
    public suspend fun templateOrigin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateOrigin = mapped
    }

    /**
     * @param value The type of the protection rule template. Valid values:
     * - **user_default:** default template.
     * - **user_custom:** custom template.
     */
    @JvmName("upvhlfsuxdmshrpx")
    public suspend fun templateType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateType = mapped
    }

    internal fun build(): DefenseTemplateArgs = DefenseTemplateArgs(
        defenseScene = defenseScene,
        defenseTemplateName = defenseTemplateName,
        description = description,
        instanceId = instanceId,
        resourceManagerResourceGroupId = resourceManagerResourceGroupId,
        status = status,
        templateOrigin = templateOrigin,
        templateType = templateType,
    )
}
