@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.wafv3.kotlin

import com.pulumi.alicloud.wafv3.kotlin.outputs.DomainListen
import com.pulumi.alicloud.wafv3.kotlin.outputs.DomainRedirect
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.alicloud.wafv3.kotlin.outputs.DomainListen.Companion.toKotlin as domainListenToKotlin
import com.pulumi.alicloud.wafv3.kotlin.outputs.DomainRedirect.Companion.toKotlin as domainRedirectToKotlin

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.alicloud.wafv3.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * Provides a Wafv3 Domain resource.
 * For information about Wafv3 Domain and how to use it, see [What is Domain](https://www.alibabacloud.com/help/en/web-application-firewall/latest/api-waf-openapi-2021-10-01-createdomain).
 * > **NOTE:** Available since v1.200.0.
 * ## Import
 * Wafv3 Domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:wafv3/domain:Domain example <instance_id>:<domain>
 * ```
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.alicloud.wafv3.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * The access type of the WAF instance. Value: **share** (default): CNAME access.
     */
    public val accessType: Output<String>?
        get() = javaResource.accessType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the domain name to query.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * WAF instance ID
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * Configure listening information. See `listen` below.
     */
    public val listen: Output<DomainListen>
        get() = javaResource.listen().applyValue({ args0 ->
            args0.let({ args0 ->
                domainListenToKotlin(args0)
            })
        })

    /**
     * Configure forwarding information. See `redirect` below.
     */
    public val redirect: Output<DomainRedirect>
        get() = javaResource.redirect().applyValue({ args0 ->
            args0.let({ args0 ->
                domainRedirectToKotlin(args0)
            })
        })

    /**
     * The ID of the resource group.
     */
    public val resourceManagerResourceGroupId: Output<String>
        get() = javaResource.resourceManagerResourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.wafv3.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.alicloud.wafv3.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
