@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.wafv3.kotlin

import com.pulumi.alicloud.wafv3.DomainArgs.builder
import com.pulumi.alicloud.wafv3.kotlin.inputs.DomainListenArgs
import com.pulumi.alicloud.wafv3.kotlin.inputs.DomainListenArgsBuilder
import com.pulumi.alicloud.wafv3.kotlin.inputs.DomainRedirectArgs
import com.pulumi.alicloud.wafv3.kotlin.inputs.DomainRedirectArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a Wafv3 Domain resource.
 * For information about Wafv3 Domain and how to use it, see [What is Domain](https://www.alibabacloud.com/help/en/web-application-firewall/latest/api-waf-openapi-2021-10-01-createdomain).
 * > **NOTE:** Available since v1.200.0.
 * ## Import
 * Wafv3 Domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:wafv3/domain:Domain example <instance_id>:<domain>
 * ```
 * @property accessType The access type of the WAF instance. Value: **share** (default): CNAME access.
 * @property domain The name of the domain name to query.
 * @property instanceId WAF instance ID
 * @property listen Configure listening information. See `listen` below.
 * @property redirect Configure forwarding information. See `redirect` below.
 */
public data class DomainArgs(
    public val accessType: Output<String>? = null,
    public val domain: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val listen: Output<DomainListenArgs>? = null,
    public val redirect: Output<DomainRedirectArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.wafv3.DomainArgs> {
    override fun toJava(): com.pulumi.alicloud.wafv3.DomainArgs =
        com.pulumi.alicloud.wafv3.DomainArgs.builder()
            .accessType(accessType?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .listen(listen?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .redirect(redirect?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var accessType: Output<String>? = null

    private var domain: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var listen: Output<DomainListenArgs>? = null

    private var redirect: Output<DomainRedirectArgs>? = null

    /**
     * @param value The access type of the WAF instance. Value: **share** (default): CNAME access.
     */
    @JvmName("coalolfcaypgbkbm")
    public suspend fun accessType(`value`: Output<String>) {
        this.accessType = value
    }

    /**
     * @param value The name of the domain name to query.
     */
    @JvmName("crpsydwvpopjmdvm")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value WAF instance ID
     */
    @JvmName("quitcsawopggbwcc")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Configure listening information. See `listen` below.
     */
    @JvmName("ifyivfdexqcyghxb")
    public suspend fun listen(`value`: Output<DomainListenArgs>) {
        this.listen = value
    }

    /**
     * @param value Configure forwarding information. See `redirect` below.
     */
    @JvmName("ghwumgkshiqswlgy")
    public suspend fun redirect(`value`: Output<DomainRedirectArgs>) {
        this.redirect = value
    }

    /**
     * @param value The access type of the WAF instance. Value: **share** (default): CNAME access.
     */
    @JvmName("axbmigbmmggykhuj")
    public suspend fun accessType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessType = mapped
    }

    /**
     * @param value The name of the domain name to query.
     */
    @JvmName("nlwpbpeclojcvwfe")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value WAF instance ID
     */
    @JvmName("wxluirekhdvxmqur")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Configure listening information. See `listen` below.
     */
    @JvmName("vckugxuvfwcakixi")
    public suspend fun listen(`value`: DomainListenArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listen = mapped
    }

    /**
     * @param argument Configure listening information. See `listen` below.
     */
    @JvmName("btgmaqikfoefcutn")
    public suspend fun listen(argument: suspend DomainListenArgsBuilder.() -> Unit) {
        val toBeMapped = DomainListenArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.listen = mapped
    }

    /**
     * @param value Configure forwarding information. See `redirect` below.
     */
    @JvmName("niveyafunsbygses")
    public suspend fun redirect(`value`: DomainRedirectArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirect = mapped
    }

    /**
     * @param argument Configure forwarding information. See `redirect` below.
     */
    @JvmName("bggxfiugtrtqaeuc")
    public suspend fun redirect(argument: suspend DomainRedirectArgsBuilder.() -> Unit) {
        val toBeMapped = DomainRedirectArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.redirect = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        accessType = accessType,
        domain = domain,
        instanceId = instanceId,
        listen = listen,
        redirect = redirect,
    )
}
